/*
 * Decompiled with CFR 0.152.
 */
package com.apple.cocoa.foundation;

import com.apple.cocoa.foundation.NSRuntime;
import java.awt.Dimension;

public class NSSize
implements Cloneable {
    public static final NSSize ZeroSize;
    float _width = 0.0f;
    float _height = 0.0f;

    public NSSize() {
    }

    public NSSize(float f, float f2) {
        if (f != f || f2 != f2) {
            throw new IllegalArgumentException("cannot create NSSize with NaN width (" + f + ") or height (" + f2 + ")");
        }
        this._width = 0.0f == f ? 0.0f : f;
        this._height = 0.0f == f2 ? 0.0f : f2;
    }

    public NSSize(NSSize nSSize) {
        this(nSSize.width(), nSSize.height());
    }

    public NSSize(Dimension dimension) {
        this(dimension.width, dimension.height);
    }

    private static boolean is_float_char(char c) {
        return '0' <= c && c <= '9' || '+' == c || '-' == c || '.' == c;
    }

    public static NSSize fromString(String string) {
        int n;
        int n2;
        int n3 = string.length();
        char[] cArray = new char[n3];
        string.getChars(0, n3, cArray, 0);
        for (n2 = 0; n2 < n3 && !NSSize.is_float_char(cArray[n2]); ++n2) {
        }
        for (n = n2; n < n3 && NSSize.is_float_char(cArray[n]); ++n) {
        }
        float f = new Float(string.substring(n2, n)).floatValue();
        for (n2 = n; n2 < n3 && !NSSize.is_float_char(cArray[n2]); ++n2) {
        }
        for (n = n2; n < n3 && NSSize.is_float_char(cArray[n]); ++n) {
        }
        float f2 = new Float(string.substring(n2, n)).floatValue();
        return new NSSize(f, f2);
    }

    public float width() {
        return this._width;
    }

    public float height() {
        return this._height;
    }

    public boolean isEmpty() {
        return this.width() <= 0.0f || this.height() <= 0.0f;
    }

    public boolean isEqualToSize(NSSize nSSize) {
        return this.width() == nSSize.width() && this.height() == nSSize.height();
    }

    public boolean equals(Object object) {
        if (object instanceof NSSize) {
            return this.isEqualToSize((NSSize)object);
        }
        return false;
    }

    public int hashCode() {
        return Math.round(this.width() + this.height());
    }

    public String toString() {
        return "{" + this.width() + ", " + this.height() + "}";
    }

    public Dimension toAWTDimension() {
        return new Dimension((int)Math.ceil(this.width()), (int)Math.ceil(this.height()));
    }

    public Object clone() {
        return new NSSize(this);
    }

    static {
        NSRuntime.loadLibrary("ObjCJava");
        NSRuntime.loadLibrary("FoundationJava");
        ZeroSize = new NSSize();
    }
}

