/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.anttask;

import edu.umd.cs.findbugs.anttask.AbstractFindBugsTask;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class FindBugsTask
extends AbstractFindBugsTask {
    private String effort;
    private boolean conserveSpace;
    private boolean sorted = true;
    private boolean timestampNow = true;
    private boolean quietErrors;
    private String warningsProperty;
    private String projectName;
    private boolean workHard;
    private boolean relaxed;
    private boolean adjustExperimental;
    private File projectFile;
    private File baselineBugs;
    private File excludeFile;
    private File includeFile;
    private Path auxClasspath;
    private Path auxAnalyzepath;
    private Path sourcePath;
    private String outputFormat = "xml";
    private String reportLevel;
    private String visitors;
    private String omitVisitors;
    private String outputFileName;
    private String stylesheet;
    private List<ClassLocation> classLocations = new ArrayList<ClassLocation>();
    private String onlyAnalyze;
    private boolean noClassOk;

    public FindBugsTask() {
        super("edu.umd.cs.findbugs.FindBugs2");
    }

    public void setWorkHard(boolean workHard) {
        this.workHard = workHard;
    }

    public void setNoClassOk(boolean noClassOk) {
        this.noClassOk = noClassOk;
    }

    public void setRelaxed(boolean relaxed) {
        this.relaxed = relaxed;
    }

    public void setAdjustExperimental(boolean adjustExperimental) {
        this.adjustExperimental = adjustExperimental;
    }

    public void setVisitors(String commaSeperatedString) {
        this.visitors = commaSeperatedString;
    }

    public void setOmitVisitors(String commaSeperatedString) {
        this.omitVisitors = commaSeperatedString;
    }

    public void setOutput(String format) {
        this.outputFormat = format;
    }

    public void setStylesheet(String stylesheet) {
        this.stylesheet = stylesheet;
    }

    public void setReportLevel(String level) {
        this.reportLevel = level;
    }

    public void setSort(boolean flag) {
        this.sorted = flag;
    }

    public void setTimestampNow(boolean flag) {
        this.timestampNow = flag;
    }

    public void setQuietErrors(boolean flag) {
        this.quietErrors = flag;
    }

    public void setWarningsProperty(String name) {
        this.warningsProperty = name;
    }

    public void setEffort(String effort) {
        this.effort = effort;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setConserveSpace(boolean flag) {
        this.conserveSpace = flag;
    }

    public void setExcludeFilter(File filterFile) {
        this.excludeFile = filterFile;
    }

    public void setIncludeFilter(File filterFile) {
        this.includeFile = filterFile;
    }

    public void setBaselineBugs(File baselineBugs) {
        this.baselineBugs = baselineBugs;
    }

    public void setProjectFile(File projectFile) {
        this.projectFile = projectFile;
    }

    public void setAuxClasspath(Path src) {
        String[] elementList;
        boolean nonEmpty = false;
        for (String anElementList : elementList = src.list()) {
            if (anElementList.equals("")) continue;
            nonEmpty = true;
            break;
        }
        if (nonEmpty) {
            if (this.auxClasspath == null) {
                this.auxClasspath = src;
            } else {
                this.auxClasspath.append(src);
            }
        }
    }

    public Path createAuxClasspath() {
        if (this.auxClasspath == null) {
            this.auxClasspath = new Path(this.getProject());
        }
        return this.auxClasspath.createPath();
    }

    public void setAuxClasspathRef(Reference r) {
        Path path = this.createAuxClasspath();
        path.setRefid(r);
        path.toString();
    }

    public void setAuxAnalyzepath(Path src) {
        String[] elementList;
        boolean nonEmpty = false;
        for (String anElementList : elementList = src.list()) {
            if (anElementList.equals("")) continue;
            nonEmpty = true;
            break;
        }
        if (nonEmpty) {
            if (this.auxAnalyzepath == null) {
                this.auxAnalyzepath = src;
            } else {
                this.auxAnalyzepath.append(src);
            }
        }
    }

    public Path createAuxAnalyzepath() {
        if (this.auxAnalyzepath == null) {
            this.auxAnalyzepath = new Path(this.getProject());
        }
        return this.auxAnalyzepath.createPath();
    }

    public void setAuxAnalyzepathRef(Reference r) {
        this.createAuxAnalyzepath().setRefid(r);
    }

    public void setSourcePath(Path src) {
        if (this.sourcePath == null) {
            this.sourcePath = src;
        } else {
            this.sourcePath.append(src);
        }
    }

    public Path createSourcePath() {
        if (this.sourcePath == null) {
            this.sourcePath = new Path(this.getProject());
        }
        return this.sourcePath.createPath();
    }

    public void setSourcePathRef(Reference r) {
        this.createSourcePath().setRefid(r);
    }

    public ClassLocation createClass() {
        ClassLocation cl = new ClassLocation();
        this.classLocations.add(cl);
        return cl;
    }

    public void setOutputFile(String outputFileName) {
        if (outputFileName != null && outputFileName.length() > 0) {
            this.outputFileName = outputFileName;
        }
    }

    public void setOnlyAnalyze(String filter) {
        this.onlyAnalyze = filter;
    }

    protected void checkParameters() {
        super.checkParameters();
        if (this.projectFile == null && this.classLocations.size() == 0 && this.auxAnalyzepath == null) {
            throw new BuildException("either projectfile, <class/> or <auxAnalyzepath/> child elements must be defined for task <" + this.getTaskName() + "/>", this.getLocation());
        }
        if (!(this.outputFormat == null || this.outputFormat.trim().equalsIgnoreCase("xml") || this.outputFormat.trim().equalsIgnoreCase("xml:withMessages") || this.outputFormat.trim().equalsIgnoreCase("html") || this.outputFormat.trim().equalsIgnoreCase("text") || this.outputFormat.trim().equalsIgnoreCase("xdocs") || this.outputFormat.trim().equalsIgnoreCase("emacs"))) {
            throw new BuildException("output attribute must be either 'text', 'xml', 'html', 'xdocs' or 'emacs' for task <" + this.getTaskName() + "/>", this.getLocation());
        }
        if (!(this.reportLevel == null || this.reportLevel.trim().equalsIgnoreCase("experimental") || this.reportLevel.trim().equalsIgnoreCase("low") || this.reportLevel.trim().equalsIgnoreCase("medium") || this.reportLevel.trim().equalsIgnoreCase("high"))) {
            throw new BuildException("reportlevel attribute must be either 'experimental' or 'low' or 'medium' or 'high' for task <" + this.getTaskName() + "/>", this.getLocation());
        }
        if (!(this.effort == null || this.effort.equals("min") || this.effort.equals("default") || this.effort.equals("max"))) {
            throw new BuildException("effort attribute must be one of 'min', 'default', or 'max'");
        }
    }

    protected void beforeExecuteJavaProcess() {
        this.log("Running FindBugs...");
    }

    protected void afterExecuteJavaProcess(int rc) {
        if ((rc & 4) != 0) {
            throw new BuildException("Execution of findbugs failed.");
        }
        if ((rc & 2) != 0) {
            this.log("Classes needed for analysis were missing");
        }
        if (this.warningsProperty != null && (rc & 1) != 0) {
            this.getProject().setProperty(this.warningsProperty, "true");
        }
        if (this.outputFileName != null) {
            this.log("Output saved to " + this.outputFileName);
        }
    }

    protected void configureFindbugsEngine() {
        if (this.projectName != null) {
            this.addArg("-projectName");
            this.addArg(this.projectName);
        }
        if (this.adjustExperimental) {
            this.addArg("-adjustExperimental");
        }
        if (this.conserveSpace) {
            this.addArg("-conserveSpace");
        }
        if (this.workHard) {
            this.addArg("-workHard");
        }
        if (this.effort != null) {
            this.addArg("-effort:" + this.effort);
        }
        if (this.sorted) {
            this.addArg("-sortByClass");
        }
        if (this.timestampNow) {
            this.addArg("-timestampNow");
        }
        if (this.outputFormat != null && !this.outputFormat.trim().equalsIgnoreCase("text")) {
            this.outputFormat = this.outputFormat.trim();
            String outputArg = "-";
            int colon = this.outputFormat.indexOf(58);
            if (colon >= 0) {
                outputArg = outputArg + this.outputFormat.substring(0, colon).toLowerCase();
                outputArg = outputArg + ":";
                outputArg = outputArg + this.outputFormat.substring(colon + 1);
            } else {
                outputArg = outputArg + this.outputFormat.toLowerCase();
                if (this.stylesheet != null) {
                    outputArg = outputArg + ":";
                    outputArg = outputArg + this.stylesheet.trim();
                }
            }
            this.addArg(outputArg);
        }
        if (this.quietErrors) {
            this.addArg("-quiet");
        }
        if (this.reportLevel != null) {
            this.addArg("-" + this.reportLevel.trim().toLowerCase());
        }
        if (this.projectFile != null) {
            this.addArg("-project");
            this.addArg(this.projectFile.getPath());
        }
        if (this.baselineBugs != null) {
            this.addArg("-excludeBugs");
            this.addArg(this.baselineBugs.getPath());
        }
        if (this.excludeFile != null) {
            this.addArg("-exclude");
            this.addArg(this.excludeFile.getPath());
        }
        if (this.includeFile != null) {
            this.addArg("-include");
            this.addArg(this.includeFile.getPath());
        }
        if (this.visitors != null) {
            this.addArg("-visitors");
            this.addArg(this.visitors);
        }
        if (this.omitVisitors != null) {
            this.addArg("-omitVisitors");
            this.addArg(this.omitVisitors);
        }
        if (this.auxClasspath != null) {
            try {
                String unreadReference = this.auxClasspath.toString();
                this.addArg("-auxclasspath");
                this.addArg(this.auxClasspath.toString());
            }
            catch (Throwable t) {
                this.log("Warning: auxClasspath " + t + " not found.");
            }
        }
        if (this.sourcePath != null) {
            this.addArg("-sourcepath");
            this.addArg(this.sourcePath.toString());
        }
        if (this.outputFileName != null) {
            this.addArg("-outputFile");
            this.addArg(this.outputFileName);
        }
        if (this.relaxed) {
            this.addArg("-relaxed");
        }
        if (this.noClassOk) {
            this.addArg("-noClassOk");
        }
        if (this.onlyAnalyze != null) {
            this.addArg("-onlyAnalyze");
            this.addArg(this.onlyAnalyze);
        }
        this.addArg("-exitcode");
        for (ClassLocation classLocation : this.classLocations) {
            this.addArg(classLocation.toString());
        }
        if (this.auxAnalyzepath != null) {
            String[] result = this.auxAnalyzepath.toString().split(File.pathSeparator);
            for (int x = 0; x < result.length; ++x) {
                this.addArg(result[x]);
            }
        }
    }

    public static class ClassLocation {
        File classLocation = null;

        public void setLocation(File location) {
            this.classLocation = location;
        }

        public File getLocation() {
            return this.classLocation;
        }

        public String toString() {
            return this.classLocation != null ? this.classLocation.toString() : "";
        }
    }
}

