/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.jaudiotagger.audio.asf.data.AsfHeader;
import org.jaudiotagger.audio.asf.io.AsfHeaderReader;
import org.jaudiotagger.audio.asf.util.TagConverter;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.generic.AudioFileReader;
import org.jaudiotagger.audio.generic.GenericAudioHeader;
import org.jaudiotagger.tag.Tag;

public class AsfFileReader
extends AudioFileReader {
    protected GenericAudioHeader getEncodingInfo(RandomAccessFile raf) throws CannotReadException, IOException {
        raf.seek(0L);
        GenericAudioHeader info = new GenericAudioHeader();
        try {
            AsfHeader header = AsfHeaderReader.readHeader(raf);
            if (header == null) {
                throw new CannotReadException("Some values must have been incorrect for interpretation as asf with wma content.");
            }
            info.setBitrate(header.getAudioStreamChunk().getKbps());
            info.setChannelNumber((int)header.getAudioStreamChunk().getChannelCount());
            info.setEncodingType("ASF (audio): " + header.getAudioStreamChunk().getCodecDescription());
            info.setPreciseLength(header.getFileHeader().getPreciseDuration());
            info.setSamplingRate((int)header.getAudioStreamChunk().getSamplingRate());
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof CannotReadException) {
                throw (CannotReadException)e;
            }
            throw new CannotReadException("Failed to read. Cause: " + e.getMessage());
        }
        return info;
    }

    protected Tag getTag(RandomAccessFile raf) throws CannotReadException, IOException {
        raf.seek(0L);
        Tag tag = null;
        try {
            AsfHeader header = AsfHeaderReader.readHeader(raf);
            if (header == null) {
                throw new CannotReadException("Some values must have been incorrect for interpretation as asf with wma content.");
            }
            tag = TagConverter.createTagOf(header);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof CannotReadException) {
                throw (CannotReadException)e;
            }
            throw new CannotReadException("Failed to read. Cause: " + e.getMessage());
        }
        return tag;
    }
}

