/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.data;

import java.util.Arrays;
import org.jaudiotagger.audio.asf.util.Utils;

public class GUID {
    public static final GUID GUID_AUDIO_ERROR_CONCEALEMENT_ABSENT;
    public static final GUID GUID_AUDIO_ERROR_CONCEALEMENT_INTERLEAVED;
    public static final GUID GUID_AUDIOSTREAM;
    public static final GUID GUID_CONTENTDESCRIPTION;
    public static final GUID GUID_ENCODING;
    public static final GUID GUID_EXTENDED_CONTENT_DESCRIPTION;
    public static final GUID GUID_FILE;
    public static final GUID GUID_HEADER;
    public static final int GUID_LENGTH = 16;
    public static final GUID GUID_STREAM;
    public static final GUID GUID_HEADER_EXTENSION;
    public static final GUID GUID_STREAM_BITRATE_PROPERTIES;
    public static final GUID GUID_VIDEOSTREAM;
    public static final GUID[] KNOWN_GUIDS;
    private String description = "";
    private int[] guid = null;

    static {
        int[] nArray = new int[16];
        nArray[0] = 64;
        nArray[1] = 164;
        nArray[2] = 241;
        nArray[3] = 73;
        nArray[4] = 206;
        nArray[5] = 78;
        nArray[6] = 208;
        nArray[7] = 17;
        nArray[8] = 163;
        nArray[9] = 172;
        nArray[11] = 160;
        nArray[12] = 201;
        nArray[13] = 3;
        nArray[14] = 72;
        nArray[15] = 246;
        GUID_AUDIO_ERROR_CONCEALEMENT_ABSENT = new GUID(nArray, "Audio error concealment absent.");
        int[] nArray2 = new int[16];
        nArray2[0] = 64;
        nArray2[1] = 164;
        nArray2[2] = 241;
        nArray2[3] = 73;
        nArray2[4] = 206;
        nArray2[5] = 78;
        nArray2[6] = 208;
        nArray2[7] = 17;
        nArray2[8] = 163;
        nArray2[9] = 172;
        nArray2[11] = 160;
        nArray2[12] = 201;
        nArray2[13] = 3;
        nArray2[14] = 72;
        nArray2[15] = 246;
        GUID_AUDIO_ERROR_CONCEALEMENT_INTERLEAVED = new GUID(nArray2, "Interleaved audio error concealment.");
        int[] nArray3 = new int[16];
        nArray3[0] = 64;
        nArray3[1] = 158;
        nArray3[2] = 105;
        nArray3[3] = 248;
        nArray3[4] = 77;
        nArray3[5] = 91;
        nArray3[6] = 207;
        nArray3[7] = 17;
        nArray3[8] = 168;
        nArray3[9] = 253;
        nArray3[11] = 128;
        nArray3[12] = 95;
        nArray3[13] = 92;
        nArray3[14] = 68;
        nArray3[15] = 43;
        GUID_AUDIOSTREAM = new GUID(nArray3, " Audio stream");
        int[] nArray4 = new int[16];
        nArray4[0] = 51;
        nArray4[1] = 38;
        nArray4[2] = 178;
        nArray4[3] = 117;
        nArray4[4] = 142;
        nArray4[5] = 102;
        nArray4[6] = 207;
        nArray4[7] = 17;
        nArray4[8] = 166;
        nArray4[9] = 217;
        nArray4[11] = 170;
        nArray4[13] = 98;
        nArray4[14] = 206;
        nArray4[15] = 108;
        GUID_CONTENTDESCRIPTION = new GUID(nArray4, "Content Description");
        int[] nArray5 = new int[16];
        nArray5[0] = 64;
        nArray5[1] = 82;
        nArray5[2] = 209;
        nArray5[3] = 134;
        nArray5[4] = 29;
        nArray5[5] = 49;
        nArray5[6] = 208;
        nArray5[7] = 17;
        nArray5[8] = 163;
        nArray5[9] = 164;
        nArray5[11] = 160;
        nArray5[12] = 201;
        nArray5[13] = 3;
        nArray5[14] = 72;
        nArray5[15] = 246;
        GUID_ENCODING = new GUID(nArray5, "Encoding description");
        int[] nArray6 = new int[16];
        nArray6[0] = 64;
        nArray6[1] = 164;
        nArray6[2] = 208;
        nArray6[3] = 210;
        nArray6[4] = 7;
        nArray6[5] = 227;
        nArray6[6] = 210;
        nArray6[7] = 17;
        nArray6[8] = 151;
        nArray6[9] = 240;
        nArray6[11] = 160;
        nArray6[12] = 201;
        nArray6[13] = 94;
        nArray6[14] = 168;
        nArray6[15] = 80;
        GUID_EXTENDED_CONTENT_DESCRIPTION = new GUID(nArray6, "Extended Content Description");
        int[] nArray7 = new int[16];
        nArray7[0] = 161;
        nArray7[1] = 220;
        nArray7[2] = 171;
        nArray7[3] = 140;
        nArray7[4] = 71;
        nArray7[5] = 169;
        nArray7[6] = 207;
        nArray7[7] = 17;
        nArray7[8] = 142;
        nArray7[9] = 228;
        nArray7[11] = 192;
        nArray7[12] = 12;
        nArray7[13] = 32;
        nArray7[14] = 83;
        nArray7[15] = 101;
        GUID_FILE = new GUID(nArray7, "File header");
        int[] nArray8 = new int[16];
        nArray8[0] = 48;
        nArray8[1] = 38;
        nArray8[2] = 178;
        nArray8[3] = 117;
        nArray8[4] = 142;
        nArray8[5] = 102;
        nArray8[6] = 207;
        nArray8[7] = 17;
        nArray8[8] = 166;
        nArray8[9] = 217;
        nArray8[11] = 170;
        nArray8[13] = 98;
        nArray8[14] = 206;
        nArray8[15] = 108;
        GUID_HEADER = new GUID(nArray8, "Asf header");
        int[] nArray9 = new int[16];
        nArray9[0] = 145;
        nArray9[1] = 7;
        nArray9[2] = 220;
        nArray9[3] = 183;
        nArray9[4] = 183;
        nArray9[5] = 169;
        nArray9[6] = 207;
        nArray9[7] = 17;
        nArray9[8] = 142;
        nArray9[9] = 230;
        nArray9[11] = 192;
        nArray9[12] = 12;
        nArray9[13] = 32;
        nArray9[14] = 83;
        nArray9[15] = 101;
        GUID_STREAM = new GUID(nArray9, "Stream");
        int[] nArray10 = new int[16];
        nArray10[0] = 181;
        nArray10[1] = 3;
        nArray10[2] = 191;
        nArray10[3] = 95;
        nArray10[4] = 46;
        nArray10[5] = 169;
        nArray10[6] = 207;
        nArray10[7] = 17;
        nArray10[8] = 142;
        nArray10[9] = 227;
        nArray10[11] = 192;
        nArray10[12] = 12;
        nArray10[13] = 32;
        nArray10[14] = 83;
        nArray10[15] = 101;
        GUID_HEADER_EXTENSION = new GUID(nArray10, "Header Extension");
        int[] nArray11 = new int[16];
        nArray11[0] = 206;
        nArray11[1] = 117;
        nArray11[2] = 248;
        nArray11[3] = 123;
        nArray11[4] = 141;
        nArray11[5] = 70;
        nArray11[6] = 209;
        nArray11[7] = 17;
        nArray11[8] = 141;
        nArray11[9] = 130;
        nArray11[11] = 96;
        nArray11[12] = 151;
        nArray11[13] = 201;
        nArray11[14] = 162;
        nArray11[15] = 178;
        GUID_STREAM_BITRATE_PROPERTIES = new GUID(nArray11, "Stream bitrate properties");
        int[] nArray12 = new int[16];
        nArray12[0] = 192;
        nArray12[1] = 239;
        nArray12[2] = 25;
        nArray12[3] = 188;
        nArray12[4] = 77;
        nArray12[5] = 91;
        nArray12[6] = 207;
        nArray12[7] = 17;
        nArray12[8] = 168;
        nArray12[9] = 253;
        nArray12[11] = 128;
        nArray12[12] = 95;
        nArray12[13] = 92;
        nArray12[14] = 68;
        nArray12[15] = 43;
        GUID_VIDEOSTREAM = new GUID(nArray12, "Video stream");
        KNOWN_GUIDS = new GUID[]{GUID_AUDIO_ERROR_CONCEALEMENT_ABSENT, GUID_AUDIO_ERROR_CONCEALEMENT_INTERLEAVED, GUID_CONTENTDESCRIPTION, GUID_AUDIOSTREAM, GUID_ENCODING, GUID_FILE, GUID_HEADER, GUID_STREAM, GUID_EXTENDED_CONTENT_DESCRIPTION, GUID_VIDEOSTREAM, GUID_HEADER_EXTENSION, GUID_STREAM_BITRATE_PROPERTIES};
    }

    public static boolean assertGUID(int[] value) {
        boolean result = false;
        if (value != null && value.length == 16) {
            result = true;
        }
        return result;
    }

    public static String getGuidDescription(GUID guid) {
        String result = null;
        if (guid == null) {
            throw new IllegalArgumentException("Argument must not be null.");
        }
        int i = 0;
        while (i < KNOWN_GUIDS.length) {
            if (KNOWN_GUIDS[i].equals(guid)) {
                result = KNOWN_GUIDS[i].getDescription();
            }
            ++i;
        }
        return result;
    }

    public GUID(int[] value) {
        this.setGUID(value);
    }

    public GUID(int[] value, String desc) {
        this(value);
        if (desc == null) {
            throw new IllegalArgumentException("Argument must not be null.");
        }
        this.description = desc;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof GUID) {
            GUID other = (GUID)obj;
            result = Arrays.equals(this.getGUID(), other.getGUID());
        } else {
            result = super.equals(obj);
        }
        return result;
    }

    public byte[] getBytes() {
        byte[] result = new byte[this.guid.length];
        int i = 0;
        while (i < result.length) {
            result[i] = (byte)(this.guid[i] & 0xFF);
            ++i;
        }
        return result;
    }

    public String getDescription() {
        return this.description;
    }

    public int[] getGUID() {
        int[] copy = new int[this.guid.length];
        System.arraycopy(this.guid, 0, copy, 0, this.guid.length);
        return copy;
    }

    public boolean isValid() {
        return GUID.assertGUID(this.getGUID());
    }

    private void setGUID(int[] value) {
        if (!GUID.assertGUID(value)) {
            throw new IllegalArgumentException("The given guid doesn't match the GUID specification.");
        }
        this.guid = new int[16];
        System.arraycopy(value, 0, this.guid, 0, 16);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        if (this.getDescription().trim().length() > 0) {
            result.append("Description: " + this.getDescription() + Utils.LINE_SEPARATOR + "   ");
        }
        int i = 0;
        while (i < this.guid.length) {
            String tmp = Integer.toHexString(this.guid[i]);
            if (tmp.length() < 2) {
                tmp = "0" + tmp;
            }
            if (i > 0) {
                result.append(", ");
            }
            result.append("0x" + tmp);
            ++i;
        }
        return result.toString();
    }
}

