/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.data;

import java.math.BigInteger;
import org.jaudiotagger.audio.asf.data.Chunk;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.util.Utils;

public class StreamChunk
extends Chunk {
    private boolean contentEncrypted;
    private int streamNumber;
    private long streamSpecificDataSize;
    private long timeOffset;
    private long typeSpecificDataSize;

    public StreamChunk(long pos, BigInteger chunkLen) {
        super(GUID.GUID_AUDIOSTREAM, pos, chunkLen);
    }

    public int getStreamNumber() {
        return this.streamNumber;
    }

    public long getStreamSpecificDataSize() {
        return this.streamSpecificDataSize;
    }

    public long getTimeOffset() {
        return this.timeOffset;
    }

    public long getTypeSpecificDataSize() {
        return this.typeSpecificDataSize;
    }

    public boolean isContentEncrypted() {
        return this.contentEncrypted;
    }

    public String prettyPrint() {
        StringBuffer result = new StringBuffer(super.prettyPrint());
        result.insert(0, String.valueOf(Utils.LINE_SEPARATOR) + "Stream Data:" + Utils.LINE_SEPARATOR);
        result.append("   Stream number: " + this.getStreamNumber() + Utils.LINE_SEPARATOR);
        result.append("   Type specific data size  : " + this.getTypeSpecificDataSize() + Utils.LINE_SEPARATOR);
        result.append("   Stream specific data size: " + this.getStreamSpecificDataSize() + Utils.LINE_SEPARATOR);
        result.append("   Time Offset              : " + this.getTimeOffset() + Utils.LINE_SEPARATOR);
        result.append("   Content Encryption       : " + this.isContentEncrypted() + Utils.LINE_SEPARATOR);
        return result.toString();
    }

    public void setContentEncrypted(boolean cntEnc) {
        this.contentEncrypted = cntEnc;
    }

    public void setStreamNumber(int streamNum) {
        this.streamNumber = streamNum;
    }

    public void setStreamSpecificDataSize(long strSpecDataSize) {
        this.streamSpecificDataSize = strSpecDataSize;
    }

    public void setTimeOffset(long timeOffs) {
        this.timeOffset = timeOffs;
    }

    public void setTypeSpecificDataSize(long typeSpecDataSize) {
        this.typeSpecificDataSize = typeSpecDataSize;
    }
}

