/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.mp4;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.mp4.Mp4NotMetaFieldKey;
import org.jaudiotagger.audio.mp4.atom.Mp4BoxHeader;
import org.jaudiotagger.audio.mp4.atom.Mp4MetaBox;
import org.jaudiotagger.tag.mp4.Mp4FieldKey;
import org.jaudiotagger.tag.mp4.Mp4NonStandardFieldKey;
import org.jaudiotagger.tag.mp4.Mp4Tag;
import org.jaudiotagger.tag.mp4.field.Mp4DiscNoField;
import org.jaudiotagger.tag.mp4.field.Mp4FieldType;
import org.jaudiotagger.tag.mp4.field.Mp4GenreField;
import org.jaudiotagger.tag.mp4.field.Mp4TagBinaryField;
import org.jaudiotagger.tag.mp4.field.Mp4TagByteField;
import org.jaudiotagger.tag.mp4.field.Mp4TagCoverField;
import org.jaudiotagger.tag.mp4.field.Mp4TagRawBinaryField;
import org.jaudiotagger.tag.mp4.field.Mp4TagReverseDnsField;
import org.jaudiotagger.tag.mp4.field.Mp4TagTextField;
import org.jaudiotagger.tag.mp4.field.Mp4TagTextNumberField;
import org.jaudiotagger.tag.mp4.field.Mp4TrackField;

public class Mp4TagReader {
    public Mp4Tag read(RandomAccessFile raf) throws CannotReadException, IOException {
        Mp4Tag tag = new Mp4Tag();
        Mp4BoxHeader moovHeader = Mp4BoxHeader.seekWithinLevel(raf, Mp4NotMetaFieldKey.MOOV.getFieldName());
        if (moovHeader == null) {
            throw new CannotReadException("This file does not appear to be an audio file");
        }
        ByteBuffer moovBuffer = ByteBuffer.allocate(moovHeader.getLength() - 8);
        raf.getChannel().read(moovBuffer);
        moovBuffer.rewind();
        Mp4BoxHeader boxHeader = Mp4BoxHeader.seekWithinLevel(moovBuffer, Mp4NotMetaFieldKey.UDTA.getFieldName());
        if (boxHeader == null) {
            throw new CannotReadException("This file does not appear to be an audio file");
        }
        boxHeader = Mp4BoxHeader.seekWithinLevel(moovBuffer, Mp4NotMetaFieldKey.META.getFieldName());
        if (boxHeader == null) {
            throw new CannotReadException("This file does not appear to be an audio file");
        }
        Mp4MetaBox meta = new Mp4MetaBox(boxHeader, moovBuffer);
        meta.processData();
        boxHeader = Mp4BoxHeader.seekWithinLevel(moovBuffer, Mp4NotMetaFieldKey.ILST.getFieldName());
        if (boxHeader == null) {
            return tag;
        }
        int length = boxHeader.getLength() - 8;
        ByteBuffer metadataBuffer = moovBuffer.slice();
        int read = 0;
        while (read < length) {
            boxHeader.update(metadataBuffer);
            this.createMp4Field(tag, boxHeader, metadataBuffer.slice());
            metadataBuffer.position(metadataBuffer.position() + boxHeader.getDataLength());
            read += boxHeader.getLength();
        }
        return tag;
    }

    private void createMp4Field(Mp4Tag tag, Mp4BoxHeader header, ByteBuffer raw) throws UnsupportedEncodingException {
        if (header.getId().equals("----")) {
            Mp4TagReverseDnsField field = new Mp4TagReverseDnsField(raw);
            tag.add(field);
        } else {
            int currentPos = raw.position();
            boolean isDataIdentifier = Utils.getString(raw, 4, 4, "ISO-8859-1").equals("data");
            raw.position(currentPos);
            if (isDataIdentifier) {
                int type = Utils.getNumberBigEndian(raw, 9, 11);
                if (header.getId().equals(Mp4FieldKey.TRACK.getFieldName())) {
                    Mp4TrackField field = new Mp4TrackField(header.getId(), raw);
                    tag.add(field);
                } else if (header.getId().equals(Mp4FieldKey.DISCNUMBER.getFieldName())) {
                    Mp4DiscNoField field = new Mp4DiscNoField(header.getId(), raw);
                    tag.add(field);
                } else if (header.getId().equals(Mp4FieldKey.GENRE.getFieldName())) {
                    Mp4GenreField field = new Mp4GenreField(header.getId(), raw);
                    tag.add(field);
                } else if (type == Mp4FieldType.TEXT.getFileClassId()) {
                    Mp4TagTextField field = new Mp4TagTextField(header.getId(), raw);
                    tag.add(field);
                } else if (type == Mp4FieldType.NUMERIC.getFileClassId()) {
                    Mp4TagTextNumberField field = new Mp4TagTextNumberField(header.getId(), raw);
                    tag.add(field);
                } else if (type == Mp4FieldType.BYTE.getFileClassId()) {
                    Mp4TagByteField field = new Mp4TagByteField(header.getId(), raw);
                    tag.add(field);
                } else if (type == Mp4FieldType.COVERART_JPEG.getFileClassId() || type == Mp4FieldType.COVERART_PNG.getFileClassId()) {
                    int processedDataSize = 0;
                    int imageCount = 0;
                    while (processedDataSize < header.getDataLength()) {
                        if (imageCount > 0) {
                            type = Utils.getNumberBigEndian(raw, processedDataSize + 9, processedDataSize + 9 + 3 - 1);
                        }
                        Mp4TagCoverField field = new Mp4TagCoverField(raw, type);
                        tag.add(field);
                        processedDataSize += field.getDataSize() + 8;
                        ++imageCount;
                    }
                } else {
                    boolean existingId = false;
                    Mp4FieldKey[] mp4FieldKeyArray = Mp4FieldKey.values();
                    int n = mp4FieldKeyArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Mp4FieldKey key = mp4FieldKeyArray[n2];
                        if (key.getFieldName().equals(header.getId())) {
                            existingId = true;
                            break;
                        }
                        ++n2;
                    }
                    if (!existingId) {
                        Mp4TagBinaryField field = new Mp4TagBinaryField(header.getId(), raw);
                        tag.add(field);
                    }
                }
            } else if (header.getId().equals(Mp4NonStandardFieldKey.AAPR.getFieldName())) {
                Mp4TagRawBinaryField field = new Mp4TagRawBinaryField(header, raw);
                tag.add(field);
            } else {
                Mp4TagRawBinaryField field = new Mp4TagRawBinaryField(header, raw);
                tag.add(field);
            }
        }
    }
}

