/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.mp4;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.CannotWriteException;
import org.jaudiotagger.audio.mp4.Mp4NotMetaFieldKey;
import org.jaudiotagger.audio.mp4.atom.Mp4BoxHeader;
import org.jaudiotagger.audio.mp4.atom.Mp4FreeBox;
import org.jaudiotagger.audio.mp4.atom.Mp4MetaBox;
import org.jaudiotagger.audio.mp4.atom.Mp4StcoBox;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.mp4.Mp4Tag;
import org.jaudiotagger.tag.mp4.Mp4TagCreator;

public class Mp4TagWriter {
    private Mp4TagCreator tc = new Mp4TagCreator();

    private void writeMetadataSameSize(ByteBuffer rawIlstData, long oldIlstSize, long startIstWithinFile, FileChannel fileReadChannel, FileChannel fileWriteChannel) throws CannotWriteException, IOException {
        fileReadChannel.position(0L);
        fileWriteChannel.transferFrom(fileReadChannel, 0L, startIstWithinFile);
        fileWriteChannel.position(startIstWithinFile);
        fileWriteChannel.write(rawIlstData);
        fileReadChannel.position(startIstWithinFile + oldIlstSize);
        fileWriteChannel.transferFrom(fileReadChannel, fileWriteChannel.position(), fileReadChannel.size() - fileReadChannel.position());
    }

    private void adjustSizeOfMoovHeader(Mp4BoxHeader moovHeader, ByteBuffer moovBuffer, int sizeAdjustment) throws IOException {
        moovHeader.setLength(moovHeader.getLength() + sizeAdjustment);
        moovBuffer.rewind();
        Mp4BoxHeader udtaHdr = Mp4BoxHeader.seekWithinLevel(moovBuffer, Mp4NotMetaFieldKey.UDTA.getFieldName());
        udtaHdr.setLength(udtaHdr.getLength() + sizeAdjustment);
        moovBuffer.position(moovBuffer.position() - 8);
        moovBuffer.put(udtaHdr.getHeaderData());
        Mp4BoxHeader metaHdr = Mp4BoxHeader.seekWithinLevel(moovBuffer, Mp4NotMetaFieldKey.META.getFieldName());
        metaHdr.setLength(metaHdr.getLength() + sizeAdjustment);
        moovBuffer.position(moovBuffer.position() - 8);
        moovBuffer.put(metaHdr.getHeaderData());
    }

    private void adjustOffsetsInStcoBox(ByteBuffer moovBuffer, int sizeAdjustment) throws IOException {
        moovBuffer.rewind();
        Mp4BoxHeader boxHeader = Mp4BoxHeader.seekWithinLevel(moovBuffer, Mp4NotMetaFieldKey.TRAK.getFieldName());
        boxHeader = Mp4BoxHeader.seekWithinLevel(moovBuffer, Mp4NotMetaFieldKey.MDIA.getFieldName());
        boxHeader = Mp4BoxHeader.seekWithinLevel(moovBuffer, Mp4NotMetaFieldKey.MINF.getFieldName());
        boxHeader = Mp4BoxHeader.seekWithinLevel(moovBuffer, Mp4NotMetaFieldKey.STBL.getFieldName());
        boxHeader = Mp4BoxHeader.seekWithinLevel(moovBuffer, Mp4NotMetaFieldKey.STCO.getFieldName());
        Mp4StcoBox stco = new Mp4StcoBox(boxHeader, moovBuffer, sizeAdjustment);
    }

    public void write(Tag tag, RandomAccessFile raf, RandomAccessFile rafTemp) throws CannotWriteException, IOException {
        long level1SearchPosition;
        int relativeIlstEndPosition;
        int relativeIlstposition;
        ByteBuffer rawIlstData = this.tc.convert(tag);
        rawIlstData.rewind();
        FileChannel fileWriteChannel = rafTemp.getChannel();
        Mp4BoxHeader moovHeader = Mp4BoxHeader.seekWithinLevel(raf, Mp4NotMetaFieldKey.MOOV.getFieldName());
        ByteBuffer moovBuffer = ByteBuffer.allocate(moovHeader.getLength() - 8);
        FileChannel fileReadChannel = raf.getChannel();
        long positionWithinFileAfterFindingMoovHeader = fileReadChannel.position();
        fileReadChannel.read(moovBuffer);
        moovBuffer.rewind();
        Mp4BoxHeader boxHeader = Mp4BoxHeader.seekWithinLevel(moovBuffer, Mp4NotMetaFieldKey.TRAK.getFieldName());
        boxHeader = Mp4BoxHeader.seekWithinLevel(moovBuffer, Mp4NotMetaFieldKey.MDIA.getFieldName());
        boxHeader = Mp4BoxHeader.seekWithinLevel(moovBuffer, Mp4NotMetaFieldKey.MINF.getFieldName());
        boxHeader = Mp4BoxHeader.seekWithinLevel(moovBuffer, Mp4NotMetaFieldKey.STBL.getFieldName());
        boxHeader = Mp4BoxHeader.seekWithinLevel(moovBuffer, Mp4NotMetaFieldKey.STCO.getFieldName());
        Mp4StcoBox stco = new Mp4StcoBox(boxHeader, moovBuffer);
        moovBuffer.rewind();
        Mp4BoxHeader.seekWithinLevel(moovBuffer, Mp4NotMetaFieldKey.UDTA.getFieldName());
        try {
            boxHeader = Mp4BoxHeader.seekWithinLevel(moovBuffer, Mp4NotMetaFieldKey.META.getFieldName());
            Mp4MetaBox meta = new Mp4MetaBox(boxHeader, moovBuffer);
            meta.processData();
        }
        catch (CannotReadException cre) {
            throw new CannotWriteException("Problem finding meta field");
        }
        int startPositionInMoovBufferForSearchingIlst = moovBuffer.position();
        boxHeader = Mp4BoxHeader.seekWithinLevel(moovBuffer, Mp4NotMetaFieldKey.ILST.getFieldName());
        int oldIlstSize = 0;
        if (boxHeader != null) {
            oldIlstSize = boxHeader.getLength();
            relativeIlstposition = moovBuffer.position() - 8;
            moovBuffer.position(moovBuffer.position() + boxHeader.getDataLength());
            relativeIlstEndPosition = moovBuffer.position();
        } else {
            moovBuffer.position(startPositionInMoovBufferForSearchingIlst);
            relativeIlstposition = startPositionInMoovBufferForSearchingIlst;
            relativeIlstEndPosition = startPositionInMoovBufferForSearchingIlst;
        }
        int newIlstSize = rawIlstData.limit();
        boxHeader = Mp4BoxHeader.seekWithinLevel(moovBuffer, Mp4NotMetaFieldKey.FREE.getFieldName());
        int oldMetaLevelFreeAtomSize = 0;
        int extraDataSize = 0;
        if (boxHeader == null) {
            oldMetaLevelFreeAtomSize = 0;
            extraDataSize = moovBuffer.limit() - relativeIlstEndPosition;
        } else {
            oldMetaLevelFreeAtomSize = boxHeader.getLength();
            extraDataSize = moovBuffer.limit() - (moovBuffer.position() + boxHeader.getDataLength());
        }
        long startIstWithinFile = positionWithinFileAfterFindingMoovHeader + (long)relativeIlstposition;
        long topLevelFreePosition = level1SearchPosition = fileReadChannel.position();
        Mp4BoxHeader topLevelFreeHeader = Mp4BoxHeader.seekWithinLevel(raf, Mp4NotMetaFieldKey.FREE.getFieldName());
        int topLevelFreeSize = 0;
        Mp4BoxHeader mdatHeader = null;
        boolean topLevelFreeAtomComesBeforeMdatAtom = true;
        if (topLevelFreeHeader == null) {
            topLevelFreeSize = 0;
            fileReadChannel.position(topLevelFreePosition);
            mdatHeader = Mp4BoxHeader.seekWithinLevel(raf, Mp4NotMetaFieldKey.MDAT.getFieldName());
            if (mdatHeader == null) {
                throw new CannotWriteException("Unable to safetly find audio data");
            }
        } else {
            topLevelFreeSize = topLevelFreeHeader.getLength();
            topLevelFreePosition = fileReadChannel.position() - 8L;
            fileReadChannel.position(topLevelFreePosition + (long)topLevelFreeHeader.getLength());
            mdatHeader = Mp4BoxHeader.seekWithinLevel(raf, Mp4NotMetaFieldKey.MDAT.getFieldName());
            if (mdatHeader == null) {
                fileReadChannel.position(level1SearchPosition);
                mdatHeader = Mp4BoxHeader.seekWithinLevel(raf, Mp4NotMetaFieldKey.MDAT.getFieldName());
                topLevelFreeAtomComesBeforeMdatAtom = false;
                if (mdatHeader == null) {
                    throw new CannotWriteException("Unable to safetly find audio data");
                }
            }
        }
        int mDatHeaderDataLocation = (int)raf.getFilePointer();
        if (oldIlstSize == newIlstSize) {
            this.writeMetadataSameSize(rawIlstData, oldIlstSize, startIstWithinFile, fileReadChannel, fileWriteChannel);
        } else if (oldIlstSize > newIlstSize) {
            int newFreeSize;
            if (oldMetaLevelFreeAtomSize > 0) {
                fileReadChannel.position(0L);
                fileWriteChannel.transferFrom(fileReadChannel, 0L, startIstWithinFile);
                fileWriteChannel.position(startIstWithinFile);
                fileWriteChannel.write(rawIlstData);
                fileReadChannel.position(startIstWithinFile + (long)oldIlstSize);
                newFreeSize = oldMetaLevelFreeAtomSize + (oldIlstSize - newIlstSize);
                Mp4FreeBox newFreeBox = new Mp4FreeBox(newFreeSize - 8);
                fileWriteChannel.write(newFreeBox.getHeader().getHeaderData());
                fileWriteChannel.write(newFreeBox.getData());
                fileReadChannel.position(fileReadChannel.position() + (long)oldMetaLevelFreeAtomSize);
                fileWriteChannel.transferFrom(fileReadChannel, fileWriteChannel.position(), fileReadChannel.size() - fileReadChannel.position());
            } else {
                newFreeSize = oldIlstSize - newIlstSize - 8;
                if (newFreeSize > 0) {
                    fileReadChannel.position(0L);
                    fileWriteChannel.transferFrom(fileReadChannel, 0L, startIstWithinFile);
                    fileWriteChannel.position(startIstWithinFile);
                    fileWriteChannel.write(rawIlstData);
                    fileReadChannel.position(startIstWithinFile + (long)oldIlstSize);
                    Mp4FreeBox newFreeBox = new Mp4FreeBox(newFreeSize);
                    fileWriteChannel.write(newFreeBox.getHeader().getHeaderData());
                    fileWriteChannel.write(newFreeBox.getData());
                    fileWriteChannel.transferFrom(fileReadChannel, fileWriteChannel.position(), fileReadChannel.size() - fileReadChannel.position());
                } else {
                    int sizeReducedBy = oldIlstSize - newIlstSize;
                    fileReadChannel.position(0L);
                    fileWriteChannel.transferFrom(fileReadChannel, 0L, positionWithinFileAfterFindingMoovHeader - 8L);
                    fileWriteChannel.position(positionWithinFileAfterFindingMoovHeader - 8L);
                    this.adjustOffsetsInStcoBox(moovBuffer, -sizeReducedBy);
                    this.adjustSizeOfMoovHeader(moovHeader, moovBuffer, -sizeReducedBy);
                    fileWriteChannel.write(moovHeader.getHeaderData());
                    moovBuffer.rewind();
                    moovBuffer.limit(relativeIlstposition);
                    fileWriteChannel.write(moovBuffer);
                    fileWriteChannel.write(rawIlstData);
                    fileReadChannel.position(startIstWithinFile + (long)oldIlstSize);
                    if (extraDataSize > 0) {
                        fileWriteChannel.transferFrom(fileReadChannel, fileWriteChannel.position(), extraDataSize);
                        fileWriteChannel.position(fileWriteChannel.position() + (long)extraDataSize);
                    }
                    fileWriteChannel.transferFrom(fileReadChannel, fileWriteChannel.position(), fileReadChannel.size() - fileReadChannel.position());
                }
            }
        } else {
            int additionalSpaceRequiredForMetadata = newIlstSize - oldIlstSize;
            if (additionalSpaceRequiredForMetadata <= oldMetaLevelFreeAtomSize - 8) {
                int newFreeSize = oldMetaLevelFreeAtomSize - additionalSpaceRequiredForMetadata;
                fileReadChannel.position(0L);
                fileWriteChannel.transferFrom(fileReadChannel, 0L, startIstWithinFile);
                fileWriteChannel.position(startIstWithinFile);
                fileWriteChannel.write(rawIlstData);
                fileReadChannel.position(startIstWithinFile + (long)oldIlstSize);
                Mp4FreeBox newFreeBox = new Mp4FreeBox(newFreeSize - 8);
                fileWriteChannel.write(newFreeBox.getHeader().getHeaderData());
                fileWriteChannel.write(newFreeBox.getData());
                fileReadChannel.position(fileReadChannel.position() + (long)oldMetaLevelFreeAtomSize);
                fileWriteChannel.transferFrom(fileReadChannel, fileWriteChannel.position(), fileReadChannel.size() - fileReadChannel.position());
            } else {
                int additionalMetaSizeThatWontFitWithinMetaAtom = additionalSpaceRequiredForMetadata - oldMetaLevelFreeAtomSize;
                fileReadChannel.position(0L);
                fileWriteChannel.transferFrom(fileReadChannel, 0L, positionWithinFileAfterFindingMoovHeader - 8L);
                fileWriteChannel.position(positionWithinFileAfterFindingMoovHeader - 8L);
                if (!topLevelFreeAtomComesBeforeMdatAtom || topLevelFreeSize - 8 < additionalMetaSizeThatWontFitWithinMetaAtom && topLevelFreeSize != additionalMetaSizeThatWontFitWithinMetaAtom) {
                    this.adjustOffsetsInStcoBox(moovBuffer, additionalMetaSizeThatWontFitWithinMetaAtom);
                }
                this.adjustSizeOfMoovHeader(moovHeader, moovBuffer, additionalMetaSizeThatWontFitWithinMetaAtom);
                fileWriteChannel.write(moovHeader.getHeaderData());
                moovBuffer.rewind();
                moovBuffer.limit(relativeIlstposition);
                fileWriteChannel.write(moovBuffer);
                fileWriteChannel.write(rawIlstData);
                fileReadChannel.position(startIstWithinFile + (long)oldIlstSize);
                fileReadChannel.position(fileReadChannel.position() + (long)oldMetaLevelFreeAtomSize);
                if (extraDataSize > 0) {
                    fileWriteChannel.transferFrom(fileReadChannel, fileWriteChannel.position(), extraDataSize);
                    fileWriteChannel.position(fileWriteChannel.position() + (long)extraDataSize);
                }
                fileReadChannel.position(level1SearchPosition);
                if (topLevelFreeAtomComesBeforeMdatAtom) {
                    if (topLevelFreeSize - 8 >= additionalMetaSizeThatWontFitWithinMetaAtom) {
                        Mp4FreeBox freeBox = new Mp4FreeBox(topLevelFreeSize - 8 - additionalMetaSizeThatWontFitWithinMetaAtom);
                        fileWriteChannel.write(freeBox.getHeader().getHeaderData());
                        fileWriteChannel.write(freeBox.getData());
                        fileReadChannel.position(fileReadChannel.position() + (long)topLevelFreeSize);
                        fileWriteChannel.transferFrom(fileReadChannel, fileWriteChannel.position(), fileReadChannel.size() - fileReadChannel.position());
                    } else if (topLevelFreeSize == additionalMetaSizeThatWontFitWithinMetaAtom) {
                        fileReadChannel.position(fileReadChannel.position() + (long)topLevelFreeSize);
                        fileWriteChannel.transferFrom(fileReadChannel, fileWriteChannel.position(), fileReadChannel.size() - fileReadChannel.position());
                    } else {
                        fileWriteChannel.transferFrom(fileReadChannel, fileWriteChannel.position(), fileReadChannel.size() - fileReadChannel.position());
                    }
                } else {
                    fileWriteChannel.transferFrom(fileReadChannel, fileWriteChannel.position(), fileReadChannel.size() - fileReadChannel.position());
                }
            }
        }
        fileReadChannel.close();
        raf.close();
        FileChannel newFileReadChannel = fileWriteChannel;
        try {
            try {
                long newLevelSearchPosition;
                newFileReadChannel.position(0L);
                Mp4BoxHeader newMoovHeader = Mp4BoxHeader.seekWithinLevel(rafTemp, Mp4NotMetaFieldKey.MOOV.getFieldName());
                ByteBuffer newMoovBuffer = ByteBuffer.allocate(newMoovHeader.getLength() - 8);
                newFileReadChannel.read(newMoovBuffer);
                newMoovBuffer.rewind();
                boxHeader = Mp4BoxHeader.seekWithinLevel(newMoovBuffer, Mp4NotMetaFieldKey.TRAK.getFieldName());
                boxHeader = Mp4BoxHeader.seekWithinLevel(newMoovBuffer, Mp4NotMetaFieldKey.MDIA.getFieldName());
                boxHeader = Mp4BoxHeader.seekWithinLevel(newMoovBuffer, Mp4NotMetaFieldKey.MINF.getFieldName());
                boxHeader = Mp4BoxHeader.seekWithinLevel(newMoovBuffer, Mp4NotMetaFieldKey.STBL.getFieldName());
                boxHeader = Mp4BoxHeader.seekWithinLevel(newMoovBuffer, Mp4NotMetaFieldKey.STCO.getFieldName());
                Mp4StcoBox newStco = new Mp4StcoBox(boxHeader, newMoovBuffer);
                newMoovBuffer.rewind();
                Mp4BoxHeader.seekWithinLevel(newMoovBuffer, Mp4NotMetaFieldKey.UDTA.getFieldName());
                try {
                    boxHeader = Mp4BoxHeader.seekWithinLevel(newMoovBuffer, Mp4NotMetaFieldKey.META.getFieldName());
                    Mp4MetaBox meta = new Mp4MetaBox(boxHeader, newMoovBuffer);
                    meta.processData();
                }
                catch (CannotReadException cre) {
                    throw new CannotWriteException("Unable to find metafield in written file");
                }
                boxHeader = Mp4BoxHeader.seekWithinLevel(newMoovBuffer, Mp4NotMetaFieldKey.ILST.getFieldName());
                newMoovBuffer.position(newMoovBuffer.position() + boxHeader.getDataLength());
                topLevelFreePosition = newLevelSearchPosition = newFileReadChannel.position();
                topLevelFreeHeader = Mp4BoxHeader.seekWithinLevel(rafTemp, Mp4NotMetaFieldKey.FREE.getFieldName());
                topLevelFreeSize = 0;
                Mp4BoxHeader newMdatHeader = null;
                int mDataDataOffset = 0;
                if (topLevelFreeHeader == null) {
                    topLevelFreeSize = 0;
                    newFileReadChannel.position(topLevelFreePosition);
                    newMdatHeader = Mp4BoxHeader.seekWithinLevel(rafTemp, Mp4NotMetaFieldKey.MDAT.getFieldName());
                    mDataDataOffset = (int)rafTemp.getFilePointer();
                    if (newMdatHeader == null) {
                        throw new CannotWriteException("Unable to safetly find audio data in file");
                    }
                } else {
                    topLevelFreeSize = topLevelFreeHeader.getLength();
                    topLevelFreePosition = newFileReadChannel.position() - 8L;
                    newFileReadChannel.position(newFileReadChannel.position() + (long)topLevelFreeHeader.getDataLength());
                    newMdatHeader = Mp4BoxHeader.seekWithinLevel(rafTemp, Mp4NotMetaFieldKey.MDAT.getFieldName());
                    mDataDataOffset = (int)rafTemp.getFilePointer();
                    if (newMdatHeader == null) {
                        newFileReadChannel.position(newLevelSearchPosition);
                        newMdatHeader = Mp4BoxHeader.seekWithinLevel(rafTemp, Mp4NotMetaFieldKey.MDAT.getFieldName());
                        mDataDataOffset = (int)rafTemp.getFilePointer();
                        if (newMdatHeader == null) {
                            throw new CannotWriteException("Unable to safetly find audio data in file");
                        }
                    }
                }
                if (mdatHeader.getDataLength() != newMdatHeader.getDataLength()) {
                    throw new CannotWriteException("Unable to write same length of audio data in file");
                }
                int diff = stco.getFirstOffSet() - mDatHeaderDataLocation;
                if (newStco.getFirstOffSet() - mDataDataOffset != diff) {
                    throw new CannotWriteException("Unable to adjust offsets in audio data:" + (newStco.getFirstOffSet() - mDataDataOffset) + ":" + diff);
                }
            }
            catch (Exception e) {
                if (e instanceof CannotWriteException) {
                    throw (CannotWriteException)e;
                }
                throw new CannotWriteException("Unable to make changes to file");
            }
        }
        finally {
            rafTemp.close();
            newFileReadChannel.close();
        }
    }

    public void delete(RandomAccessFile raf, RandomAccessFile rafTemp) throws IOException {
        Mp4Tag tag = new Mp4Tag();
        try {
            this.write(tag, raf, rafTemp);
        }
        catch (CannotWriteException cwe) {
            throw new IOException(cwe.getMessage());
        }
    }
}

