/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.datatype;

import java.util.Arrays;
import org.jaudiotagger.audio.mp3.MP3File;
import org.jaudiotagger.tag.InvalidDataTypeException;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;

public abstract class AbstractDataType {
    protected static final String TYPE_ELEMENT = "element";
    protected Object value = null;
    protected String identifier = "";
    protected AbstractTagFrameBody frameBody = null;
    protected int size;

    protected AbstractDataType(String identifier, AbstractTagFrameBody frameBody) {
        this.identifier = identifier;
        this.frameBody = frameBody;
    }

    protected AbstractDataType(String identifier, AbstractTagFrameBody frameBody, Object value) {
        this.identifier = identifier;
        this.frameBody = frameBody;
        this.setValue(value);
    }

    public AbstractDataType(AbstractDataType copyObject) {
        this.identifier = new String(copyObject.identifier);
        if (copyObject.value == null) {
            this.value = null;
        } else if (copyObject.value instanceof String) {
            this.value = new String((String)copyObject.value);
        } else if (copyObject.value instanceof Boolean) {
            this.value = (Boolean)copyObject.value;
        } else if (copyObject.value instanceof Byte) {
            this.value = (Byte)copyObject.value;
        } else if (copyObject.value instanceof Character) {
            this.value = (Character)copyObject.value;
        } else if (copyObject.value instanceof Double) {
            this.value = (Double)copyObject.value;
        } else if (copyObject.value instanceof Float) {
            this.value = (Float)copyObject.value;
        } else if (copyObject.value instanceof Integer) {
            this.value = (Integer)copyObject.value;
        } else if (copyObject.value instanceof Long) {
            this.value = (Long)copyObject.value;
        } else if (copyObject.value instanceof Short) {
            this.value = (Short)copyObject.value;
        } else if (copyObject.value instanceof boolean[]) {
            this.value = ((boolean[])copyObject.value).clone();
        } else if (copyObject.value instanceof byte[]) {
            this.value = ((byte[])copyObject.value).clone();
        } else if (copyObject.value instanceof char[]) {
            this.value = ((char[])copyObject.value).clone();
        } else if (copyObject.value instanceof double[]) {
            this.value = ((double[])copyObject.value).clone();
        } else if (copyObject.value instanceof float[]) {
            this.value = ((float[])copyObject.value).clone();
        } else if (copyObject.value instanceof int[]) {
            this.value = ((int[])copyObject.value).clone();
        } else if (copyObject.value instanceof long[]) {
            this.value = ((long[])copyObject.value).clone();
        } else if (copyObject.value instanceof short[]) {
            this.value = ((short[])copyObject.value).clone();
        } else if (copyObject.value instanceof Object[]) {
            this.value = ((Object[])copyObject.value).clone();
        } else {
            throw new UnsupportedOperationException("Unable to create copy of class " + copyObject.getClass());
        }
    }

    public void setBody(AbstractTagFrameBody frameBody) {
        this.frameBody = frameBody;
    }

    public AbstractTagFrameBody getBody() {
        return this.frameBody;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public final void readByteArray(byte[] arr) throws InvalidDataTypeException {
        this.readByteArray(arr, 0);
    }

    public abstract int getSize();

    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractDataType)) {
            return false;
        }
        AbstractDataType object = (AbstractDataType)obj;
        if (!this.identifier.equals(object.identifier)) {
            return false;
        }
        if (this.value == null && object.value == null) {
            return true;
        }
        if (this.value == null || object.value == null) {
            return false;
        }
        return !(this.value instanceof boolean[] && object.value instanceof boolean[] ? !Arrays.equals((boolean[])this.value, (boolean[])object.value) : (this.value instanceof byte[] && object.value instanceof byte[] ? !Arrays.equals((byte[])this.value, (byte[])object.value) : (this.value instanceof char[] && object.value instanceof char[] ? !Arrays.equals((char[])this.value, (char[])object.value) : (this.value instanceof double[] && object.value instanceof double[] ? !Arrays.equals((double[])this.value, (double[])object.value) : (this.value instanceof float[] && object.value instanceof float[] ? !Arrays.equals((float[])this.value, (float[])object.value) : (this.value instanceof int[] && object.value instanceof int[] ? !Arrays.equals((int[])this.value, (int[])object.value) : (this.value instanceof long[] && object.value instanceof long[] ? !Arrays.equals((long[])this.value, (long[])object.value) : (this.value instanceof Object[] && object.value instanceof Object[] ? !Arrays.equals((Object[])this.value, (Object[])object.value) : (this.value instanceof short[] && object.value instanceof short[] ? !Arrays.equals((short[])this.value, (short[])object.value) : !this.value.equals(object.value))))))))));
    }

    public abstract void readByteArray(byte[] var1, int var2) throws InvalidDataTypeException;

    public abstract byte[] writeByteArray();

    public void createStructure() {
        MP3File.getStructureFormatter().addElement(this.identifier, this.getValue().toString());
    }
}

