/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.mp4.field;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.jaudiotagger.tag.mp4.Mp4FieldKey;
import org.jaudiotagger.tag.mp4.field.Mp4FieldType;
import org.jaudiotagger.tag.mp4.field.Mp4TagBinaryField;

public class Mp4TagCoverField
extends Mp4TagBinaryField {
    private Mp4FieldType imageType;

    public Mp4TagCoverField() {
        super(Mp4FieldKey.ARTWORK.getFieldName());
    }

    public Mp4TagCoverField(ByteBuffer raw, int type) throws UnsupportedEncodingException {
        super(Mp4FieldKey.ARTWORK.getFieldName(), raw);
        this.imageType = type == Mp4FieldType.COVERART_JPEG.getFileClassId() ? Mp4FieldType.COVERART_JPEG : Mp4FieldType.COVERART_PNG;
    }

    public Mp4TagCoverField(byte[] data) {
        super(Mp4FieldKey.ARTWORK.getFieldName(), data);
        this.imageType = 137 == (data[0] & 0xFF) || 80 == (data[0] & 0xFF) || 78 == (data[0] & 0xFF) || 71 == (data[0] & 0xFF) ? Mp4FieldType.COVERART_PNG : Mp4FieldType.COVERART_JPEG;
    }

    public Mp4FieldType getFieldType() {
        return this.imageType;
    }

    public boolean isBinary() {
        return true;
    }

    public String toString() {
        switch (this.imageType) {
            case COVERART_JPEG: {
                return "jpeg:" + this.dataBytes.length + "bytes";
            }
            case COVERART_PNG: {
                return "png" + this.dataBytes.length + "bytes";
            }
        }
        return "";
    }
}

