/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.spi;

import com.google.inject.spi.SourceProviders;
import com.google.inject.util.Objects;

public class Message {
    final Object source;
    final String message;
    String sourceString = null;

    public Message(Object source, String message) {
        this.source = Objects.nonNull(source, "source");
        this.message = Objects.nonNull(message, "message");
    }

    public Message(String message) {
        this(SourceProviders.UNKNOWN_SOURCE, message);
    }

    public Object getSource() {
        return this.source;
    }

    public String getSourceString() {
        if (this.sourceString == null) {
            this.sourceString = this.source.toString();
        }
        return this.sourceString;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return this.getSourceString() + " " + this.message;
    }

    public int hashCode() {
        return this.source.hashCode() * 31 + this.message.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Message)) {
            return false;
        }
        Message e = (Message)o;
        return this.source.equals(e.source) && this.message.equals(e.message);
    }
}

