/*
 * Decompiled with CFR 0.152.
 */
package com.onionnetworks.io;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FiniteInputStream
extends FilterInputStream {
    protected long left;

    public int read() throws IOException {
        byte[] b = new byte[1];
        if (this.read(b, 0, 1) == -1) {
            return -1;
        }
        return b[0] & 0xFF;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.left == 0L && len > 0) {
            return -1;
        }
        int c = this.in.read(b, off, (int)Math.min((long)len, this.left));
        if (c < 0) {
            throw new EOFException();
        }
        this.left -= (long)c;
        return c;
    }

    public long skip(long n) throws IOException {
        long result = this.in.skip(Math.min(n, this.left));
        this.left -= result;
        return result;
    }

    public int available() throws IOException {
        return (int)Math.min((long)this.in.available(), this.left);
    }

    public FiniteInputStream(InputStream is, long count) {
        super(is);
        if (is == null) {
            throw new NullPointerException();
        }
        if (count < 0L) {
            throw new IllegalArgumentException("count must be > 0");
        }
        this.left = count;
    }
}

