package hayashi.yuu.tools;

import java.util.ArrayList;

public abstract class DataConverter {
    /**
     * ASCII文字列
     * @param data
     * @return	文字列が戻る
     */
    public static String toString(ArrayList<Byte> byteArray) {
    	StringBuffer sbuf = new StringBuffer();
    	for (Byte b : byteArray) {
			sbuf.append(toHexString(b));
    	}
    	return sbuf.toString();
    }

    /**
     * ASCII文字列
     * @param data
     * @return	文字列が戻る
     */
    public static String toAsciiString(ArrayList<Byte> byteArray) {
    	StringBuffer sbuf = new StringBuffer();
    	for (Byte b : byteArray) {
			sbuf.append(toChar(b));
    	}
    	return sbuf.toString();
    }

    /**
     * ASCII文字列
     * @param data
     * @return	文字列が戻る
     */
    public static String toAsciiString(ArrayList<Byte> byteArray, int start, int leng) {
    	StringBuffer sbuf = new StringBuffer();
    	for (int i = start; i < (start + leng); i++) {
    		sbuf.append(toChar(byteArray.get(i).intValue()));
    	}
    	return sbuf.toString();
    }

    /**
     * １バイト数値を16進文字列で表現する。
     * 
     * @param data
     * @return	２文字の文字列が戻る
     */
    public static String toHexString(int data) {
    	String hex = Integer.toHexString(data & 0x000000ff);
    	return (hex.length() < 2 ? "0" : "") + hex;
    }

    /**
     * バイト数値が表現している「ＡＳＣＩＩ文字」
     * @param data
     * @return　ＡＳＣＩＩ文字
     */
    public static char toChar(int data) {
        for(int i = 0; i < pattern.length(); i++) {
            if(pattern.charAt(i) == data) {
                return pattern.charAt(i);
            }
        }
        return '?';
    }
    static StringBuffer pattern = new StringBuffer("0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ.,/][@;:|^~+-=)('&%$#!_?*\\<>");

}
