#define EXTERN /**/

/************************************************************************
** Copyright (C) 2006 Shinji Kono
** 連絡先： 琉球大学情報工学科 河野 真治  
** （E-Mail Address: kono@ie.u-ryukyu.ac.jp）
**
**    このソースのいかなる複写，改変，修正も許諾します。ただし、
**    その際には、誰が貢献したを示すこの部分を残すこと。
**    再配布や雑誌の付録などの問い合わせも必要ありません。
**    営利利用も上記に反しない範囲で許可します。
**    バイナリの配布の際にはversion messageを保存することを条件とします。
**    このプログラムについては特に何の保証もしない、悪しからず。
**
**    Everyone is permitted to do anything on this program 
**    including copying, modifying, improving,
**    as long as you don't try to pretend that you wrote it.
**    i.e., the above copyright notice has to appear in all copies.  
**    Binary distribution requires original version messages.
**    You don't have to ask before copying, redistribution or publishing.
**    THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE.
***********************************************************************/
#include <stdio.h>
#include "mc.h"
#include "mc-parse.h"
#include "mc-codegen.h"

#include "conv/conv.h"
#include "conv/convdef.h"
#include "conv/cbc2c.h"

extern void type_print(int type,NMTBL *nptr,FILE *out);
extern void type_print1(int type,NMTBL *nptr,FILE *out,int cont);
extern void sym_print(int type,FILE *out);

static FILE *vout,*svout;
static FILE *null;
static FILE *hout;

static void
expr_(int c)
{
}

static void
bool_(int c)
{
}

static void
comment_(int c)
{
    fprintf(vout,"%c",c);
}

static void
open_(char *s)
{
    char *p;
    p = make_filename_with_extension(s,"cbc.c");
#if 1
    vout = fopen(p,"w");
#else
    vout = stderr;p=p;
#endif
    p = make_filename_with_extension(s,"cbc.h");
    hout = fopen(p,"w");
    null=fopen("/dev/null","w");
    if (!vout) error(-1);
}

static void
conv_()
{
    vout=svout;
}

static void
noconv_(int c)
{
    svout=vout;
    vout=c?null:vout;
}

static void
print_(char *s)
{
    fprintf(vout,"c: %s\n",s);
}

static void
close_()
{
    fclose(vout);
}

void
case_begin_(int cases,int def){
    fprintf(vout,"case ");
}

void
case_(int cases,int def){
    if (def)
	fprintf(vout,"default:");
    else
	fprintf(vout,"%d:",car(cases));
}

void
code_(NMTBL *n){
    int args;
    args=n->dsp;
    fprintf(vout,"code %s(",n->nm);
    while(args) {
	n=ncadddr(args);
	type_print(n->ty,n,vout);
	args=cadr(args);
	if(args) fprintf(vout,",");
    }
    fprintf(vout,")");
}

void
code_end_(){
    fprintf(vout,"}");
}

void
comma_(){
    fprintf(vout,",");
}

void
cond_(){

}

void
cond1_(){
    fprintf(vout,"?");
}

void
cond2_(){
    fprintf(vout,":");
}

void
cond_end_(){

}

void
decl_data_begin_(){

}

void
decl_data_end_(){

}

void
def_(NMTBL *n){
}

void
dowhile_(){
    fprintf(vout,"do");
}

void
dowhile_cond_(){
    fprintf(vout,"while(");
}

void
dowhile_end_(int cond){
    fprintf(vout,");");
}

int
error_(int n){
    return 0;
}

void
extern_(){
    fprintf(vout,"extern ");
}

void
for_(){
    fprintf(vout,"for(");
}

void
for1_(){
    fprintf(vout,";");
}

void
for2_(int cond){
    fprintf(vout,";");
}

void
for_body_(int conti){
    fprintf(vout,")");
}

void
for_end_(int p0,int p1,int e){


}

void
funcall_(int type){
    fprintf(vout,"(");
}

void
funcall_args_(int f, int t, int arg){
    fprintf(vout,")");
}

void
function_(NMTBL *n,int cont){
    int args;
    type_print1(cadr(n->ty),0,vout,cont);
    fprintf(vout,"%s(",n->nm);
    args=n->dsp;
    while(args) {
	n=ncadddr(args);
	if (n==&str_ret) {
	    args=cadr(args); continue;
	}
	type_print(n->ty,n,vout);
	args=cadr(args);
	if(args) {
	    /* if(caddr(args)==(int)&str_ret) break; */
	    fprintf(vout,",");
	}
    }
    fprintf(vout,")");
}

void
function_end_(){

}

void
goto_(){
    fprintf(vout,"goto ");
}

void
goto_label_(){

}

void
id_(int sym,NMTBL *nptr){
    char *p = nptr->nm;
    for(;*p && *p!='.';p++) fputc(*p,vout);
}

void
string_(char *s,int len){
    int c;
    fprintf(vout,"\"");
    while((c=*s++)) {
	if(c=='\n') fprintf(vout,"\\n");
	else if(c=='\r') fprintf(vout,"\\r");
	else if(c=='\t') fprintf(vout,"\\t");
	else if(c=='\e') fprintf(vout,"\\e");
	else if(c=='"') fprintf(vout,"\\\"");
	else if(c=='\\') fprintf(vout,"\\\\");
	else if(!(' '<=c&&c<=0x7f)) fprintf(vout,"\\%03o",c);
	else fprintf(vout,"%c",c);
    }
    fprintf(vout,"\"");
}

void
const_(int symval){
    fprintf(vout,"%d",symval);
}

void
return_f_(){
    fprintf(vout,"return");
}

void
defined_(char *s){
    fprintf(vout,"defined(%s)",s);
}

void
environment_(){
    fprintf(vout,"environment");
}

void
if_(){
    fprintf(vout,"if (");
}

void
if_else_(){
    fprintf(vout," else ");
}

void
if_endif_(){
}

void
if_then_(int cond){
    fprintf(vout,")");
}

void
jump_(int env){

}

void
label_(){
    fprintf(vout,"%s:",nptr->nm);
}

void
lpar_(){
    fprintf(vout,"(");
}

void
rpar_(){
    fprintf(vout,")");
}

void
lbra_(int sym){
    fprintf(vout,"[");
}

void
rbra_(int sym){
    fprintf(vout,"]");
}

void
lc_(){
    fprintf(vout,"{");
}

void
rc_(){
    fprintf(vout,"}");
}

void
localvar_end_(){

}

void
op_(int sym){
    sym_print(sym,vout);
}

void
postfix_(int sym){
    sym_print(sym,vout);
}

void
prefix_(int sym){
    sym_print(sym,vout);
}

void
register_(){
    fprintf(vout,"register ");
}

void
return_(){
    fprintf(vout,"return ");
}

void
return_end_(int e){
    fprintf(vout,";");
}

void
return_type_(int t,NMTBL *nptr,int cont){
    type_print1(t,nptr,vout,cont);
}

void
sm_(){
    fprintf(vout,";");
}

void
static_(){
    fprintf(vout,"static ");
}

void
switch_(){
    fprintf(vout,"switch (");
}

void
switch_body_(int v){
    fprintf(vout,")");
}

void
switch_end_(int cases){
}

void
typedef_(){
    fprintf(vout,"typedef ");
}

void
type_(int t){
    type_print(t,0,vout);
}

void
sdecl_(int s)
{
    fprintf(vout,s==UNION?"union ":"struct ");
}

void
while_(){
    fprintf(vout,"while (");
}

void
while_body_(int cond){
    fprintf(vout,")");
}

void
while_end_(){
}

void
decl_data_()
{
}

void
break_()
{
    fprintf(vout,"break;");
}

void
continue_()
{
    fprintf(vout,"continue;");
}


/* end */
