#include <stdio.h>
#include "matrix.h"

void compute();
double ** create_identity_matrix(int size);
double ** multiply(double **a, double **b, int l, int m, int n);
void print_matrix(double **a, int row, int col);

int
main(int argc, char **argv)
{
	compute();
	return 0;
}

void
compute()
{
	double **A, **B, **C;
	A = create_identity_matrix(4);
	B = create_identity_matrix(4);
	printf("A = \n");
	print_matrix(A, 4, 4);
	printf("B = \n");
	print_matrix(B, 4, 4);

	C = multiply(A, B, 4,4,4);
	printf("C = \n");
	print_matrix(C, 4, 4);


	free(A);
	free(B);
	free(C);
}

double **
create_identity_matrix(int size)
{
	int i,j;
	double **ret;
	ret = create_matrix(sizeof(double), size, size);

	for (j=0; j<size; j++) {
		for (i=0; i<size; i++) {
			ret[j][i] = 0;
		}
	}
	for (i=0; i<size; i++) {
		ret[i][i] = 1.0f;
	}
	return ret;
}

double **
power_of_matrix(double **a, int n)
{
	int r,c,i;
	double **result;
	result = create_identity_matrix(n);

	for (r=0; r<l; r++) {
		for (c=0; c<n; c++) {
			result[r][c] = 0;
			for (i=0; i<m; i++) {
				result[r][c] += a[r][i] * b[i][c];
			}
		}
	}
	return result;
}

double **
multiply(double **a, double **b, int l, int m, int n)
{
	int r,c,i;
	double **result;
	result = create_matrix(sizeof(double), l, n);

	for (r=0; r<l; r++) {
		for (c=0; c<n; c++) {
			result[r][c] = 0;
			for (i=0; i<m; i++) {
				result[r][c] += a[r][i] * b[i][c];
			}
		}
	}
	return result;
}

/** 表示用 */
void
print_matrix(double **a, int row, int col)
{
        int i,j;
        for( j=0; j<row; j++){
                printf("\t");
                for( i=0; i<col; i++){
                        printf("%6.2f ", a[j][i]);
                }
                printf("\n");
        }
}




