#ifndef INCLUDED_SPE_THREADS
#define INCLUDED_SPE_THREADS

#include <libspe2.h>
#include <pthread.h>
#include "Threads.h"

#define SPE_ELF "spe-main"

typedef struct arg {
    int speid;
    spe_context_ptr_t ctx;
} thread_arg_t;


class SpeThreads : Threads {
public:
    /* constructor */
    SpeThreads(int num = 1);
    ~SpeThreads(void);

    /* functions */
    void init(void);
    int get_mail(int speid, int count, memaddr *ret); // BLOCKING
    int has_mail(int speid, int count, memaddr *ret); // NONBLOCK
    void send_mail(int speid, int num, memaddr *data); // BLOCKING
    static void *spe_thread_run(void *arg);
    static void *frontend_thread_run(void *arg);
    void add_output_tasklist(int command, memaddr buff, int alloc_size);

private:
    /* variables */
    spe_program_handle_t *spe_handle;
    spe_context_ptr_t *spe_ctx;
    pthread_t *threads;
    thread_arg_t *args;
    int cpu_num;
};

#endif
