#ifndef INCLUDED_DMA_MANAGER
#define INCLUDED_DMA_MANAGER

#include "base.h"
#include "ListData.h"
#include "types.h"

enum dma_tag {
    DMA_READ  = 25,
    DMA_READ2  = 26,
    DMA_WRITE = 27,
//    DMA_READ_IN_LIST  = 29,
//    DMA_READ_OUT_LIST = 30,
    DMA_READ_TASKLIST = 31,
};

class Scheduler;

class DmaManager {
public:
    virtual ~DmaManager() {};

    BASE_NEW_DELETE(DmaManager);

    // API for DMA transfer
    virtual void dma_load(void *buf, memaddr addr, uint32 size, uint32 mask) {}
    virtual void dma_store(void *buf,memaddr addr, uint32 size, uint32 mask) {}
    virtual void dma_wait(uint32 mask) {}
    virtual void dma_wait(uint32 mask, int cmd) {}
    virtual void show_dma_wait(Scheduler *s, int cpu) {}
    virtual void start_profile() {}

    // API for SPU inbound/outbound mailbox
    virtual void mail_write(memaddr data) {}
    virtual void mail_write_queue(memaddr data) {}
    virtual void mail_write_finish_list(memaddr data) {}
    virtual memaddr mail_read() { return 0; }
    virtual memaddr task_list_mail_read() { return 0; }
    
    // API for MFC list DMA transfer
    virtual void dma_loadList(ListDataPtr list, void *,uint32 mask) {}
    virtual void dma_storeList(ListDataPtr, void *buff, uint32 mask) {}
};

#endif
