#include <stdio.h>
#include <stdlib.h>
#include "CellTaskListInfo.h"

#define NEXT_ADDR(addr, size) \
    (TaskListPtr)((memaddr)(addr) + (size))

int
CellTaskListInfo::extend_pool(int num)
{
    TaskListPtr q = NULL;
    int unit_size;
    
    unit_size = (ROUND_UP_ALIGN(sizeof(TaskList), DEFAULT_ALIGNMENT));
    posix_memalign((void**)&q, DEFAULT_ALIGNMENT, unit_size*(num+1));

    if (q == NULL) {
        return -1;
    }
    
    q->next = taskListPool;
    taskListPool = q;
    
    /* Connect all free pack_list in the pool */
    q = NEXT_ADDR(taskListPool, unit_size); // q = taskListPool + 1;
    for (; --num > 0; q = NEXT_ADDR(q, unit_size)) {
        q->next = NEXT_ADDR(q, unit_size); // q->next = q + 1;
    }
    q->next = freeTaskList;
    freeTaskList = NEXT_ADDR(taskListPool, unit_size);

    return 0;
}
