#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "FifoDmaManager.h"

void
FifoDmaManager::dma_load(void *buf, memaddr addr, uint32 size, uint32 mask)
{
    if (size == 0) return;
    memcpy(buf, (void*)addr, size);
}

void
FifoDmaManager::dma_store(void *buf, memaddr addr, uint32 size, uint32 mask)
{
    if (size == 0) return;
    memcpy((void*)addr, buf, size);
}

/**
 * mask で設定した DMA 転送の完了を待つ
 */
void
FifoDmaManager::dma_wait(uint32 mask)
{
}


void
FifoDmaManager::dma_loadList(ListDataPtr list, void *buff, uint32 mask)
{
    int list_size = list->length;
    long bound;

    bound = (long)(buff);

    for (int i = 0; i < list_size; i++) {
	ListElementPtr elm = &list->element[i];
	memcpy((void*)bound, (void*)elm->addr, elm->size);
	bound += elm->size;
    }
}


void
FifoDmaManager::dma_storeList(ListDataPtr list, void *buff, uint32 mask)
{
    int list_size = list->length;
    memaddr bound;

    bound = (memaddr)(buff);

    for (int i = 0; i < list_size; i++) {
	ListElementPtr elm = &list->element[i];
	memcpy((void*)elm->addr, (void*)bound, elm->size);
	bound += elm->size;
    }
}

/* end */
