#include "TaskManager.h"
#include "Scheduler.h"
#include "HTask.h"
#include "Task.h"
#include "SysFunc.h"

TaskManager::TaskManager(int num) : machineNum(num)
{
}

TaskManager::~TaskManager()
{
    delete m_impl;
}

/**
 * create_impl(int);
 *
 * [cell版] ../../Cell/CellTaskManagerImpl.cpp
 * [fifo版] ../../Fifo/FifoTaskManagerImpl.cpp
 * で定義されています。コンパイル時に
 *
 * % make cell ってすると cell 版が、
 * % make fifo ってすると fifo 版 がリンクされるようにしているので
 * それに応じて create_impl が返す値を変えています。
 * cell だったら CellManagerImpl, fifo だったら FifoManagerImpl です。
 *
 * 今までは ifdef CELL とか書いてましたわ。どっちがいいかね
 *
 * てか、普通に TaskManagerImpl に関数持たせた方が早いか・・・？
 */
extern TaskManagerImpl* create_impl(int);

void
TaskManager::init(int spuIdle)
{
    m_impl = create_impl(machineNum);
    m_impl->init(spuIdle);
    m_impl->systask_init();
}

void
TaskManager::finish()
{
    delete m_impl;
}

/**
 * @param [command]   Task executes method number
 *
 * @return this task
 */
HTaskPtr
TaskManager::create_task(int cmd)
{
    return m_impl->create_task(cmd,__builtin_return_address(0));
}

HTaskPtr 
TaskManager::create_task(int cmd, memaddr r, long rs, memaddr w, long ws)
{
    return m_impl->create_task(cmd,r,rs,w,ws,__builtin_return_address(0));
}

HTaskPtr 
TaskManager::create_task_array(int id, int num_task, int num_param, int num_inData, int num_outData) {
    return m_impl->create_task_array(id, num_task, num_param, num_inData, num_outData,__builtin_return_address(0)) ;
}

/**
 * TaskManaer 終了時に実行される関数の設定
 */
void
TaskManager::set_TMend(void (*endf)(TaskManager *manager))
{
    tm_end = endf;
}

void
TaskManager::run()
{
    m_impl->run();
}

void*
TaskManager::allocate(int size) {
    return m_impl->allocate(size);
}

int
TaskManager::get_cpuNum()
{
    return machineNum;
}

int
TaskManager::get_random()
{
    return random();
}

MemList*
TaskManager::createMemList(int size, int count)
{
    return get_scheduler()->createMemList(size, count);
}

Scheduler*
TaskManager::get_scheduler() {
    return m_impl->get_scheduler();
}

/* end */
