#include <stdio.h>
#include "TaskManager/MailManager.h"

static void
fail(const char *reason)
{
    printf("MailManagerTest failed %s", reason);
}

static void
tester(MailManagerPtr m, int size)
{

    for(int i=0;i<size;i++) {
	m->send((memaddr)i);
    }
    for(int i=0;i<size;i++) {
	if (m->count()==0) { 
	    fail("early read fail\n"); break;
	}
	if (m->recv()!=(memaddr)i) { 
	    fail("read data fail\n"); break;
	}
    }
}

static void
test1() {
    MailManagerPtr m = new MailManager();
    tester(m,16);
    tester(m,32);
    tester(m,48);
    delete m; 
    MailManagerPtr m1 = new MailManager(40);
    tester(m1,16);
    tester(m1,48);
    delete m1;
}

int
main(int ac, const char *av[])
{
    test1();
    printf("MailManagerTest succeed\n");
}

/* end */
