#!/usr/bin/perl
#
# Author: Shinji KONO <kono@ie.u-ryukyu.ac.jp>
# v.0.1   Sat May 30 04:41:18 JST 2009
#
# fix spu-gcc assembler soruce for DMA loadable PIC code
# 
#$(OVLOBJS): %.o : %.cc
#        $(SPECC) $(SPECFLAGS) -c $< -S -o $(<:.cc=.s) 
#        perl spe/fixpic.pl $(<:.cc=.s)  | $(SPECC) $(SPECFLAGS) -x assembler -c  -o $@ -

use strict;

my %global;
my %local;
my %weak;
my @line;

# Basically SPU code is PIC. But linked library is in the fixed
# address space.
# 
# rewrite relative to absolute for global branch address
# 
# Target instruction
#   hbrr -> hbra
#   br   -> bra
#   brsl -> brasl
#   brnz cannot be global

#   lqr -> li  (for global)
#   ila    global -> a $0,.LC0-.,$1

while(<>) {
    push(@line,$_);
    if(/\.global\s+([^\s]+)/) {
        $global{$1} = 1;
    }
    if(/\.weak\s+([^\s]+)/) {
        $weak{$1} = 1;
	next;
    }
    if(/^([^\s]+):/) {
        $local{$1} = 1;
    }
}
	
for(@line) {
    if (! /^#/) {
	next if (/\.section\s+\.rodata/);
	if (/\s(brsl|hbrr|br)\s+[^\s]+,\s*(\d+[fb])/) {
	} elsif(/\s(br)\s+([^\s]+)/||/\s(brsl|hbrr)\s+[^\s]+,\s*([^\s]+)/) {
          my $name = $2;
          if (! defined $local{$name} || defined $weak{$name} ) {
		s/hbrr/hbra/ ||
		s/brsl/brasl/ ||
		s/br/bra/ ;
          }
	}

#       } elsif(/\s(lqr)\s+(\$\d+),([^\s]+)/) {
#          my $name = $2;
#          if (! defined $local{$name} || defined $weak{$name} ) {
#	    s/lqr/lqd/;
#          }
#       } elsif(/\s(ila)\s+(\$\d+),([^\s]+)/) {
#          my $name = $3;
#          if (! defined $local{$name} || defined $weak{$name} ) {
#	    $_ = $_;
#	  } else {
#	    $_ = "\tai\t$2,\$0,$3-.\n";
#          }
    }
    print ;
}

# end
