#!/usr/bin/perl
# //    from readelf -all spu/spe_main
# //   [12] .data             PROGBITS        00000f20 0011a0 000384 00  WA  0   0 16
# //      109: 00001260    64 OBJECT  GLOBAL DEFAULT   12 _ovly_table

use strict;

package ReadElf;

sub new { bless {} }

sub readelf {
    my ($self,$elf)= @_;

    my $debug = 0;
    my $section_header;
    my $symbol_table;
    my %section;
    my %symbol;

    $self->{section} = \%section;
    $self->{symbol} = \%symbol;

    open(ELF, "readelf -all $elf |");
    while(<ELF>) {
	    if(/^Section Headers:/) { $section_header = 1 ; $symbol_table = 0; }
	    elsif(/^Symbol table/) { $section_header = 0 ; $symbol_table = 1; }
	    elsif(/^[A-Z]/) { $section_header = 0 ; $symbol_table = 0; }
	    if ($section_header) {
		    if (/\[\s*(\d+)\]\s+(\.\w+)\s+(\w+)\s+([\da-f]+)\s+([\da-f]+)\s+([\da-f]+)\s/) {
		    $section{$2} = {nr=>$1,name=>$2,type=>$3,addr=>$4,offset=>$5,size=>$6};
		    }
	    }
	    if ($symbol_table) {
		    if(/^\s+(\d+):\s([\da-f]+)\s+([\da-f]+)\s+(\w+)\s+(\w+)\s+(\w+)\s+(\w+)\s+([\w\.\_]+)/) {
		    $symbol{$8} = {num=>$1,value=>$2,size=>$3,type=>$4,bind=>$5,vis=>$6,ndx=>$7,name=>$8};
		    }
	    }

    }


    if ($debug) {
	    print "seciton:\n";
	    foreach my $key ( keys %section) {
		foreach my $i ( keys %{$section{$key}}) {
		   print "$i=>$section{$key}->{$i} ";
		}
		print "\n";
	    }

	    print "symbol:\n";
	    foreach my $key ( keys %symbol) {
		foreach my $i ( keys %{$symbol{$key}}) {
		   print "$i=>$symbol{$key}->{$i} ";
		}
		print "\n";
	    }
    }
    $self;
}

sub symbol {
    my ($self, $name) = @_;
    $self->{symbol}->{$name};
}

sub segment {
    my ($self, $name) = @_;
    $self->{section}->{$name};
}


package Main;

my $elf = ReadElf->new;

my $file = shift;
if (! -e $file) {
    open(H,">runTask_offset.h");
    for my $header (@ARGV) {
	open(HD,"<$header") or die("Can't open $header");
	my $class = $header;
	my $entry = 0;
	$class =~ s/\.cc//;
	while(<HD>) {
	    if (/SchedDefineDynamicTask\(\s*(\w+)\s*,\s*(\d+)\s*\)/) {
		print H "#define runTask_${class}_offset 0x$entry\n";
		last;
	    }
	}
    }
    exit(0);
}

$elf->readelf($file) ;

my $base = $elf->segment(".segment0")->{addr};

my @ldfiles;
my $ldsegment = "";

open(H,">runTask_offset.h");
print H "#ifndef RUNTASK_OFFSET_H\n";
print H "#define RUNTASK_OFFSET_H\n";
for my $header (@ARGV) {
    open(HD,"<$header") or die("Can't open $header");
    while(<HD>) {
	if (/SchedDefineDynamicTask\(\s*(\w+)\s*,\s*(\d+)\s*\)/) {
	    my $class = $1;
	    my $segment = $2;
	    my $entry = $elf->symbol("runTask_$class")->{value};
	    print H "#define runTask_${class}_offset (0x$entry-0x$base)\n";
            my $ofile = $header;
	    $ofile =~ s/\.cc/.o/;
            push(@ldfiles,$ofile);
	    $ldsegment .= "   .segment$segment { $ofile(.text) }\n";
	    last;
	}
    }
}
print H "#endif\n";

my $ld_script = <<"EOFEOF";
/ \\.text /
/\\\*\(\\.text/
s/\\\*\(\\.text/\*\( EXCLUDE_FILE(@ldfiles) .text/
/} =0/
a
  OVERLAY :
  {
$ldsegment
  }
.
w
EOFEOF

open(H,">ldscript.ed");
print H $ld_script;

# end
