#include "Func.h"
#include "Scheduler.h"

#include "runTask_offset.h"

SchedExternDynamicTask(Hello,0);
SchedExternDynamicTask(Hello1,1);

void print_ovly_table();

/**
 * この関数は SpeScheduler から呼ばれるので
 * 必ずこの関数名でお願いします。
 */
void
task_init(Scheduler *scheduler)
{
    SchedRegisterDynamicTask(HELLO_TASK, Hello, 0);
    SchedRegisterDynamicTask(HELLO_TASK1, Hello1, 1);
    // createTask_Hello(scheduler);
    scheduler->allocate_code_segment(1024,4, _ovly_table);
    print_ovly_table();
}


/*
extern struct tbl1 {
    u32 vma;
    u32 size;
    u32 file_offset;
    u32 buf;
} _ovly_table;
 */

#ifdef NO_OVERLAY
void
print_ovly_table() {}
#else

typedef unsigned int u32;
extern unsigned long long _EAR_;
void
print_ovly_table()
{
    int i;
    struct tbl *ov;

    ov = _ovly_table;

    fprintf(stderr,"memaddr = %ld\n",sizeof(memaddr));	
    for(i=0;i<2;i++) {
        unsigned long long adr = _EAR_;
        fprintf(stderr,"ovly_table[%d] vma=%08x size=%08x offset=%08x address=%08llx\n",
               i, 
                ov[i].vma,
                ov[i].size, ov[i].file_offset, 
               (adr) + ov[i].file_offset);
    }
}
#endif

/* end */
