#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "TaskManager.h"
#include "Func.h"

extern void task_init(void);

static int count = 1;

const char *usr_help_str = "Usage: ./hello [-cpu spe_num] [-count N]\n\
  -cpu    Number of SPE (default 1) \n\
  -count  Number of task is print \"Hello, World!!\"";

int
init(int argc, char **argv)
{
    for (int i = 1; argv[i]; ++i) {
	if (strcmp(argv[i], "-count") == 0) {
            count = atoi(argv[++i]);
        }

    }

    return 0;
}

void
hello_init(TaskManager *manager)
{
    HTask *hello;

    for (int i = 0; i < count; i++) {
	/**
	 * Create Task
	 *   create_task(Task ID);
	 */
	hello = manager->create_task(HELLO_TASK);

	/**
	 * Select CPU
	 *   SPE_0, SPE_1, SPE_2, SPE_3, SPE_4, SPE_5, SPE_ANY
	 *   if you do not call this, execute PPE.
	 */
	hello->set_cpu(SPE_ANY);

	/**
	 * Set 32bits parameter
	 *   add_param(32bit parameter);
	 */
	hello->add_param((memaddr)i);

	hello->spawn();
    }
}

int
TMmain(TaskManager *manager, int argc, char *argv[])
{
    if (init(argc, argv) < 0) {
	return -1;
    }

    // Task Register
    //   ppe/task_init.cc
    task_init();

    hello_init(manager);

    return 0;
}
