/**
 * SPU Decrementerを用いた処理時間計測
 */

#include "SpeProfile.h"
/* DMA転送に関する関数を使用するために必要なインクルードファイル */
#include <spu_intrinsics.h>
#include <stdio.h>

/* SPU Decrementerの初期値 */
#define SPU_DECREMENTER_INITIAL_VALUE 0x7FFFFFFFU

SpeProfile::SpeProfile(void): profile(0) {}

void SpeProfile::ProfStart(void)
{
    /* SPU Decrementerに初期値を設定 */
    spu_writech(SPU_WrDec, SPU_DECREMENTER_INITIAL_VALUE);

    /* 計測開始時間をSPU Decrementerから読み取る */
    profile = spu_readch(SPU_RdDec);    
}

void SpeProfile::ProfStop(void)
{
    /* 計測終了時間をSPU Decrementerから読み取り, 計測開始時間との差を計算 */
    profile -= spu_readch(SPU_RdDec);    
}

void SpeProfile::ProfPrint(void)
{
    /* 処理時間を出力 */
    printf("SPE time by SPU Decrementer: %f\n",
	   profile / 79800000.0f * 1000.0f);
}
