#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "TaskManager.h"
#include "Func.h"

extern void task_init();

int *idata;
int numtask = 1;
int length = DATA_NUM;

const char *usr_help_str = "Usage: ./share [-task numtask] [-length data_length]\n \
  -task   Number of task (default 1)                           \n  \
  -length    Number of data (default DATA_NUM (Func.h))";

void
run_start(TaskManager *manager)
{
    HTaskPtr task_load;
    HTaskPtr task_exec;

    idata = (int*)manager->allocate(sizeof(int)*length);
    for (int i = 0; i < length; i++) {
		idata[i] = i;
    }

    // idata を SPU の共有領域へコピーするタスク (所謂準備的な)
    task_load = manager->create_task(TASK_LOAD);
    task_load->add_inData(idata, sizeof(int)*length);
    task_load->set_param(0,(memaddr)length);
    task_load->set_cpu(SPE_ANY);

    // task_load が作った領域を見ていくタスク (複数で共有して)
    for (int i = 0; i < numtask; i++) {
	task_exec = manager->create_task(TASK_EXEC);
	task_exec->set_param(0,(memaddr)length);
	task_exec->set_param(1,(memaddr)i);
	task_exec->set_param(2,(memaddr)ADD_NUM);
	task_exec->set_cpu(SPE_ANY);

	// dependency
	task_exec->wait_for(task_load);
	task_exec->spawn();
    }

    // add Active Queue
    task_load->spawn();
}

int
init(int argc, char **argv)
{
    for (int i = 1; argv[i]; ++i) {
	if (strcmp(argv[i], "-task") == 0) {
	    numtask = atoi(argv[++i]);
	}
	if (strcmp(argv[i], "-length") == 0) {
	    length = atoi(argv[++i]);
	}
    }

    return 0;
}

//---------main関数-----------
int
TMmain(TaskManager *manager, int argc, char *argv[])
{

    if (init(argc, argv) < 0) {
	return -1;
    }

    task_init();

    run_start(manager);

    return 0;
}
