#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "TaskManager.h"
#include "Func.h"
#include "main.h"

extern void task_init(void);

static int count = 10;

extern TaskManager *manager;

extern void queueInfoTest(int count);

static	QueueInfo<TaskQueue> *mainPool = new QueueInfo<TaskQueue>() ;

const char *usr_help_str = "Usage: ./hello [-cpu spe_num] [-count N]\n\
  -cpu    Number of SPE (default 1) \n\
  -count  Number of task is print \"Hello, World!!\"";

int
init(int argc, char **argv)
{
    for (int i = 1; argv[i]; ++i) {
	if (strcmp(argv[i], "-count") == 0) {
            count = atoi(argv[++i]);
        }

    }

    return 0;
}

Queues queues;

static void
repeat(SchedTask *s, void *arg, void *dm)
{
    static int count = 4;
    QueuePtr q = (QueuePtr) arg;
    TaskManager *manager = q->m;

    if (count-->0) {
        HTask *t = manager->create_task(HELLO_TASK);
        t->set_post(repeat, arg, 0);
        t->set_param(0,(memaddr)q->i);
        t->set_param(1,(memaddr)arg);
        t->spawn();

        printf("[PPE] Create Task : Hello count=%d id=%d\n\n",count, q->i);
    } else {
        printf("[PPE] End Task : Hello id=%d\n\n", q->i);
    }
}

void
hello_init(TaskManager *manager)
{

    if (count >MAX_QUEUE) return;

    queues.m = manager;
    queues.i = 0;
    for (int i = 0; i < MAX_QUEUE; i++) {
	QueueInfo<TaskQueue> *q = new QueueInfo<TaskQueue>(mainPool) ;
	// QueueInfo<TaskQueue> *q = new QueueInfo<TaskQueue>() ;  // wrong
	queues.q[i] = q;
    }

    for (int i = 0; i < count; i++) {
	/**
	 * Create Task
	 *   create_task(Task ID);
	 */
	HTask *hello = manager->create_task(HELLO_TASK);

	/**
	 * Select CPU
	 *   SPE_0, SPE_1, SPE_2, SPE_3, SPE_4, SPE_5, SPE_ANY
	 *   if you do not call this, execute PPE.
	 */
	hello->set_cpu(SPE_ANY);

	/**
	 * Set 32bits parameter
	 *   add_param(32bit parameter);
	 */
	QueuePtr q = (QueuePtr) manager->allocate(sizeof(Queues));

	q->i = i;
	q->m = manager;
	for (int j = 0; j < MAX_QUEUE; j++) {
	    q->q[j] = queues.q[j];
	}

	hello->set_param(0,(memaddr)i);
	hello->set_param(1,(memaddr)&queues);
	hello->set_post(repeat, (void*) &queues, 0);

	hello->spawn();
    }
}

int
TMmain(TaskManager *manager, int argc, char *argv[])
{
    if (init(argc, argv) < 0) {
	return -1;
    }
    if (count<2) count = 2;

    // Task Register
    //   ppe/task_init.cc
    task_init();

    queueInfoTest(count);
    hello_init(manager);

    return 0;
}
