#include <stdio.h>
#include "SchedTask.h"
#include "Hello.h"
#include "Func.h"
#include "main.h"

/* これは必須 */
SchedDefineTask(Hello);



static int
run(SchedTask *smanager, void *rbuf, void *wbuf)
{
    long task_id = (long)smanager->get_param(0);
    QueuePtr q = (QueuePtr) smanager->get_param(1);

    smanager->printf("[%d] Hello, World!!\n", task_id);

    for(int i=0;i<100;i++) {
	QueueInfo<TaskQueue> *i0 = q->q[i%MAX_QUEUE];
	QueueInfo<TaskQueue> *i1 = q->q[(i+1)%MAX_QUEUE];
	TaskQueue *q0;
	TaskQueue *q1;

	switch(q->m->get_random() % 4) {
	case 0:
	    q0 = i0->create(); i0->init(0);
	    q1 = i1->create(); i1->init(0);
	    i1->addLast(q0);
	    i0->addLast(q1);
	    break;
	case 1:
	    if (TaskQueue *p = i0->poll()) {
		i1->addLast(p);
	    }
	    break;
	case 2:
	    if (TaskQueue *p = i1->poll()) {
		i0->addLast(p);
	    }
	    break;
	case 3:
	    if (TaskQueue *p = i0->poll()) {
		i0->free_(p);
	    }
	    if (TaskQueue *p = i1->poll()) {
		i1->free_(p);
	    }
	    break;
	}
    }


    return 0;
}
