/*
 * Decompiled with CFR 0.152.
 */
package watij.elements;

import watij.WatijTestCase;
import watij.elements.Image;
import watij.elements.Images;
import watij.finders.SymbolFactory;

public class ImagesTest
extends WatijTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        ie.goTo(HTML_ROOT + "images1.html");
    }

    public void testImageExists() throws Exception {
        ImagesTest.assertTrue((!ie.image(SymbolFactory.name, "missing_name").exists() ? 1 : 0) != 0);
        ImagesTest.assertTrue((boolean)ie.image(SymbolFactory.name, "circle").exists());
        ImagesTest.assertTrue((boolean)ie.image(SymbolFactory.name, "/circ/").exists());
        ImagesTest.assertTrue((!ie.image(SymbolFactory.id, "missing_id").exists() ? 1 : 0) != 0);
        ImagesTest.assertTrue((boolean)ie.image(SymbolFactory.id, "square").exists());
        ImagesTest.assertTrue((boolean)ie.image(SymbolFactory.id, "/squ/").exists());
        ImagesTest.assertTrue((!ie.image(SymbolFactory.src, "missingsrc.gif").exists() ? 1 : 0) != 0);
        ImagesTest.assertTrue((boolean)ie.image(SymbolFactory.src, "/triangle/").exists());
        ImagesTest.assertTrue((boolean)ie.image(SymbolFactory.alt, "circle").exists());
        ImagesTest.assertTrue((boolean)ie.image(SymbolFactory.alt, "/cir/").exists());
        ImagesTest.assertTrue((!ie.image(SymbolFactory.alt, "triangle").exists() ? 1 : 0) != 0);
        ImagesTest.assertTrue((!ie.image(SymbolFactory.alt, "/tri/").exists() ? 1 : 0) != 0);
        ImagesTest.assertTrue((boolean)ie.image(SymbolFactory.title, "square_image").exists());
        ImagesTest.assertTrue((!ie.image(SymbolFactory.title, "pentagram").exists() ? 1 : 0) != 0);
    }

    public void testImageClick() throws Exception {
        this.assertRaisesUnknownObjectExceptionForMethodClick(ie.image(SymbolFactory.name, "no_image_with_this"));
        this.assertRaisesUnknownObjectExceptionForMethodClick(ie.image(SymbolFactory.id, "no_image_with_this"));
        this.assertRaisesUnknownObjectExceptionForMethodClick(ie.image(SymbolFactory.src, "no_image_with_this"));
        this.assertRaisesUnknownObjectExceptionForMethodClick(ie.image(SymbolFactory.alt, "no_image_with_this"));
        ie.textField(SymbolFactory.name, "text1").clear();
        ie.button(SymbolFactory.value, "/Pos/").click();
        ImagesTest.assertEquals((String)"clicked", (String)ie.textField(SymbolFactory.name, "text1").value());
        ImagesTest.assertTrue((!ie.image(SymbolFactory.name, "disabler_test").disabled() ? 1 : 0) != 0);
        ie.button(SymbolFactory.name, "disable_img").click();
        ImagesTest.assertTrue((boolean)ie.image(SymbolFactory.name, "disabler_test").disabled());
        ie.button(SymbolFactory.name, "disable_img").click();
        ie.image(SymbolFactory.src, "/button/").click();
        ImagesTest.assertTrue((boolean)ie.text().contains("PASS"));
    }

    public void testImageHasLoaded() throws Exception {
        this.assertRaisesUnknownObjectExceptionForMethodHasLoaded(ie.image(SymbolFactory.name, "no_image_with_this"));
        this.assertRaisesUnknownObjectExceptionForMethodHasLoaded(ie.image(SymbolFactory.id, "no_image_with_this"));
        this.assertRaisesUnknownObjectExceptionForMethodHasLoaded(ie.image(SymbolFactory.src, "no_image_with_this"));
        this.assertRaisesUnknownObjectExceptionForMethodHasLoaded(ie.image(SymbolFactory.alt, "no_image_with_this"));
        ImagesTest.assertFalse((boolean)ie.image(SymbolFactory.name, "themissingimage").hasLoaded());
        ImagesTest.assertTrue((boolean)ie.image(SymbolFactory.name, "circle").hasLoaded());
        ImagesTest.assertTrue((boolean)ie.image(SymbolFactory.alt, "circle").hasLoaded());
        ImagesTest.assertTrue((boolean)ie.image(SymbolFactory.alt, "/cir/").hasLoaded());
    }

    public void testImageProperties() throws Exception {
        this.assertRaisesUnknownObjectExceptionForMethodHasLoaded(ie.image(SymbolFactory.name, "no_image_with_this"));
        this.assertRaisesUnknownObjectExceptionForMethodHasLoaded(ie.image(SymbolFactory.id, "no_image_with_this"));
        this.assertRaisesUnknownObjectExceptionForMethodHasLoaded(ie.image(SymbolFactory.src, "no_image_with_this"));
        this.assertRaisesUnknownObjectExceptionForMethodHasLoaded(ie.image(82));
        this.assertRaisesUnknownObjectExceptionForMethodName(ie.image(82));
        this.assertRaisesUnknownObjectExceptionForMethodId(ie.image(82));
        this.assertRaisesUnknownObjectExceptionForMethodSrc(ie.image(82));
        this.assertRaisesUnknownObjectExceptionForMethodValue(ie.image(82));
        this.assertRaisesUnknownObjectExceptionForMethodHeight(ie.image(82));
        this.assertRaisesUnknownObjectExceptionForMethodWidth(ie.image(82));
        this.assertRaisesUnknownObjectExceptionForMethodFileCreatedDate(ie.image(82));
        this.assertRaisesUnknownObjectExceptionForMethodFileSize(ie.image(82));
        this.assertRaisesUnknownObjectExceptionForMethodAlt(ie.image(82));
        this.assertRaisesUnknownObjectExceptionForMethodTitle(ie.image(82));
        ImagesTest.assertEquals((String)"", (String)ie.image(1).name());
        ImagesTest.assertEquals((String)"square", (String)ie.image(1).id());
        ImagesTest.assertTrue((boolean)ie.image(1).src().contains("square"));
        ImagesTest.assertEquals((String)"", (String)ie.image(1).value());
        ImagesTest.assertEquals((int)88, (int)ie.image(1).height());
        ImagesTest.assertEquals((int)88, (int)ie.image(1).width());
        ImagesTest.assertEquals((int)788, (int)ie.image(1).fileSize());
        ImagesTest.assertEquals((String)"circle", (String)ie.image(5).alt());
        ImagesTest.assertEquals((String)"", (String)ie.image(1).alt());
        ImagesTest.assertEquals((String)"square_image", (String)ie.image(SymbolFactory.id, "square").title());
    }

    public void testImageIterator() throws Exception {
        ImagesTest.assertEquals((int)6, (int)ie.images().length());
        ImagesTest.assertEquals((String)"", (String)((Image)ie.images().get(1)).name());
        ImagesTest.assertEquals((String)"square", (String)((Image)ie.images().get(1)).id());
        ImagesTest.assertTrue((boolean)((Image)ie.images().get(1)).src().contains("square.jpg"));
        int i = 0;
        Images images = ie.images();
        for (Image image : images) {
            ImagesTest.assertEquals((String)ie.image(i).id(), (String)image.id());
            ImagesTest.assertEquals((String)ie.image(i).name(), (String)image.name());
            ImagesTest.assertEquals((String)ie.image(i).src(), (String)image.src());
            ImagesTest.assertEquals((int)ie.image(i).height(), (int)image.height());
            ImagesTest.assertEquals((int)ie.image(i).width(), (int)image.width());
            ++i;
        }
        ImagesTest.assertEquals((int)i, (int)ie.images().length());
    }
}

