/*
 * Decompiled with CFR 0.152.
 */
package watij.runtime.ie;

import com.jniwrapper.win32.ie.dom.HTMLElement;
import com.jniwrapper.win32.ie.dom.TextControl;
import org.w3c.dom.Element;
import watij.elements.TextField;
import watij.finders.Symbol;
import watij.runtime.NotImplementedYetException;
import watij.runtime.ObjectReadOnlyException;
import watij.runtime.ie.IE;
import watij.runtime.ie.IEHtmlElement;
import watij.utilities.StringUtils;

public class IETextField
extends IEHtmlElement
implements TextField {
    public IETextField(Element element, IE ie) throws Exception {
        super(element, ie);
    }

    private TextControl textControl() throws Exception {
        return (TextControl)this.htmlElement();
    }

    public void set(String value) throws Exception {
        this.assertEnabled();
        this.assertNotReadOnly();
        this.setText(this.textControl(), value);
    }

    public int size() throws Exception {
        return (int)this.textControl().getSize().getWidth();
    }

    public boolean verifyContains(String what) throws Exception {
        return StringUtils.matchesOrEquals(what, this.value());
    }

    private void setText(TextControl textControl, String value) throws Exception {
        this.fireBeforeSetEvents((HTMLElement)textControl);
        textControl.setValue(value);
        this.fireAfterSetEvents((HTMLElement)textControl);
    }

    public void append(String append) throws Exception {
        this.set(this.get() + append);
    }

    public void assertNotReadOnly() throws Exception {
        if (this.readOnly()) {
            throw new ObjectReadOnlyException();
        }
    }

    public void clear() throws Exception {
        this.assertEnabled();
        this.set("");
    }

    public void dragContentsTo(Symbol destinationHow, String destinationWhat) throws NotImplementedYetException {
        throw new NotImplementedYetException();
    }

    public String getContents() throws Exception {
        return this.get();
    }

    public int maxLength() throws Exception {
        return Integer.valueOf(this.textControl().getAttribute("maxLength"));
    }

    public boolean readOnly() throws Exception {
        return Boolean.valueOf(this.textControl().getAttribute("readOnly"));
    }

    public String get() throws Exception {
        return this.textControl().getValue();
    }
}

