/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.ui;

import com.jniwrapper.Function;
import com.jniwrapper.Parameter;
import com.jniwrapper.UInt;
import com.jniwrapper.UInt32;
import com.jniwrapper.win32.LastErrorException;
import com.jniwrapper.win32.ui.User32;
import com.jniwrapper.win32.ui.Wnd;

public class Timer
extends UInt {
    private static final String FUNCTION_SET_TIMER = "SetTimer";
    private static final String FUNCTION_KILL_TIMER = "KillTimer";
    private Wnd _wnd;
    private long _timerID;
    private long _timeout;
    private Callback _callback;

    public Timer(Wnd wnd, long timerID, long timeout, Callback callback) {
        this._wnd = wnd;
        this._timerID = timerID;
        this._timeout = timeout;
        this._callback = callback;
    }

    public Wnd getWnd() {
        return this._wnd;
    }

    public long getTimerID() {
        return this._timerID;
    }

    public long getTimeout() {
        return this._timeout;
    }

    public Callback getCallback() {
        return this._callback;
    }

    public void start() {
        Function function = User32.getInstance().getFunction(FUNCTION_SET_TIMER);
        long errorCode = function.invoke((Parameter)this, (Parameter)this._wnd, (Parameter)new UInt(this._timerID), (Parameter)new UInt(this._timeout), (Parameter)this._callback);
        if (this.getValue() == 0L) {
            throw new LastErrorException(errorCode, "Failed to create a timer.", true);
        }
    }

    public void stop() {
        Function function = User32.getInstance().getFunction(FUNCTION_KILL_TIMER);
        function.invoke(null, (Parameter)this._wnd, (Parameter)new UInt(this._timerID));
    }

    public static abstract class Callback
    extends com.jniwrapper.Callback {
        private Wnd _wnd = new Wnd();
        private UInt _msg = new UInt();
        private UInt _timerID = new UInt();
        private UInt32 _time = new UInt32();

        public Callback() {
            this.init(new Parameter[]{this._wnd, this._msg, this._timerID, this._time}, null);
        }

        public Wnd getWnd() {
            return this._wnd;
        }

        public UInt getMsg() {
            return this._msg;
        }

        public UInt getTimerID() {
            return this._timerID;
        }

        public UInt32 getTime() {
            return this._time;
        }
    }
}

