/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.ui;

import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.Structure;
import com.jniwrapper.jawt.JAWT;
import com.jniwrapper.jawt.JAWT_DrawingSurface;
import com.jniwrapper.jawt.JAWT_DrawingSurfaceInfo;
import com.jniwrapper.util.Logger;
import com.jniwrapper.win32.ui.Win32DSI;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import sun.awt.windows.WToolkit;

public class WindowTools {
    private static final Logger LOG = Logger.getInstance((Class)(class$com$jniwrapper$win32$ui$WindowTools == null ? (class$com$jniwrapper$win32$ui$WindowTools = WindowTools.class$("com.jniwrapper.win32.ui.WindowTools")) : class$com$jniwrapper$win32$ui$WindowTools));
    static /* synthetic */ Class class$com$jniwrapper$win32$ui$WindowTools;
    static /* synthetic */ Class class$java$awt$Component;
    static /* synthetic */ Class class$sun$awt$windows$WToolkit;

    private WindowTools() {
    }

    public static long getWindowHandle(final Component component, boolean runInCurrentThread) {
        final long[] result = new long[1];
        Runnable runnable = new Runnable(){

            public void run() {
                if (JAWT.JDK_1_4) {
                    Component heavyComp = component;
                    while (heavyComp instanceof JComponent) {
                        if ((heavyComp = heavyComp.getParent()) != null) continue;
                        result[0] = 0L;
                        return;
                    }
                    JAWT_DrawingSurface ds = JAWT.getDrawingSurface((Component)heavyComp);
                    if ((ds.lock() & 1) != 0) {
                        result[0] = 0L;
                    } else {
                        Win32DSI win32DSI = new Win32DSI();
                        JAWT_DrawingSurfaceInfo dsi = new JAWT_DrawingSurfaceInfo((Structure)win32DSI);
                        Pointer pDsi = new Pointer((Parameter)dsi);
                        ds.getDrawingSurfaceInfo(pDsi);
                        result[0] = (int)win32DSI.getHandle().getValue();
                        ds.freeDrawingSurfaceInfo(pDsi);
                        ds.unlock();
                        JAWT.freeDrawingSurface((JAWT_DrawingSurface)ds);
                    }
                } else {
                    try {
                        Method method = (class$sun$awt$windows$WToolkit == null ? (class$sun$awt$windows$WToolkit = WindowTools.class$("sun.awt.windows.WToolkit")) : class$sun$awt$windows$WToolkit).getMethod("getNativeWindowHandleFromComponent", class$java$awt$Component == null ? (class$java$awt$Component = WindowTools.class$("java.awt.Component")) : class$java$awt$Component);
                        result[0] = ((Integer)method.invoke((Object)WToolkit.getWToolkit(), component)).intValue();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e.toString());
                    }
                }
            }
        };
        WindowTools.runInDispatchThread(runnable, runInCurrentThread);
        return result[0];
    }

    public static long getWindowHandle(Component component) {
        return WindowTools.getWindowHandle(component, false);
    }

    private static void runInDispatchThread(Runnable runnable, boolean runInCurrentThread) {
        if (runInCurrentThread) {
            runnable.run();
        } else if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException e) {
                LOG.error((Object)"", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof RuntimeException) {
                    RuntimeException runtimeException = (RuntimeException)e.getTargetException();
                    throw runtimeException;
                }
                LOG.error((Object)"", (Throwable)e);
            }
        }
    }

    public static Component getComponentFromHandle(final int handle) {
        final Component[] result = new Component[1];
        Runnable runnable = new Runnable(){

            public void run() {
                if (JAWT.JDK_1_4) {
                    result[0] = JAWT.getComponentFromHandle((Pointer.Void)new Pointer.Void((long)handle));
                } else {
                    try {
                        Method method = (class$sun$awt$windows$WToolkit == null ? (class$sun$awt$windows$WToolkit = WindowTools.class$("sun.awt.windows.WToolkit")) : class$sun$awt$windows$WToolkit).getMethod("getComponentFromNativeWindowHandle", class$java$awt$Component == null ? (class$java$awt$Component = WindowTools.class$("java.awt.Component")) : class$java$awt$Component);
                        result[0] = (Component)method.invoke((Object)WToolkit.getWToolkit(), new Integer(handle));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e.toString());
                    }
                }
            }
        };
        WindowTools.runInDispatchThread(runnable, false);
        return result[0];
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

