/*
 * Decompiled with CFR 0.152.
 */
package watij;

import watij.WatijTestCase;
import watij.finders.SymbolFactory;
import watij.runtime.ie.IE;

public class ChildBrowserTest
extends WatijTestCase {
    IE ie;

    protected void setUp() throws Exception {
        this.ie = new IE();
        this.ie.start();
        this.ie.goTo(HTML_ROOT + "new_browser.html");
    }

    protected void tearDown() throws Exception {
        this.ie.close();
    }

    public void testChildBrowser() throws Exception {
        this.ie.link(SymbolFactory.text, "New Window").click();
        IE ie_new = this.ie.childBrowser();
        ChildBrowserTest.assertTrue((this.ie.childBrowserCount() == 1 ? 1 : 0) != 0);
        ChildBrowserTest.assertTrue((boolean)ie_new.text().contains("PASS"));
        ie_new.close();
        this.ie.waitUntilReady();
        System.out.println(this.ie.childBrowserCount());
        ChildBrowserTest.assertTrue((this.ie.childBrowserCount() == 0 ? 1 : 0) != 0);
        this.ie.goTo(HTML_ROOT + "textfields1.html");
        ChildBrowserTest.assertTrue((boolean)this.ie.textField(SymbolFactory.name, "text1").exists());
    }

    public void testOpenCloseMultipleChildBrowser() throws Exception {
        this.ie.link(SymbolFactory.text, "New Window").click();
        IE ie_new = this.ie.childBrowser();
        ChildBrowserTest.assertTrue((this.ie.childBrowserCount() == 1 ? 1 : 0) != 0);
        ChildBrowserTest.assertTrue((boolean)ie_new.text().contains("PASS"));
        ie_new.close();
        ChildBrowserTest.assertTrue((this.ie.childBrowserCount() == 0 ? 1 : 0) != 0);
        this.ie.link(SymbolFactory.text, "New Window").click();
        ie_new = this.ie.childBrowser();
        ChildBrowserTest.assertTrue((this.ie.childBrowserCount() == 1 ? 1 : 0) != 0);
        ChildBrowserTest.assertTrue((boolean)ie_new.text().contains("PASS"));
        ie_new.close();
    }

    public void testClosingMultipleWindows() throws Exception {
        this.ie.link(SymbolFactory.text, "Open New Browser Launcher").click();
        IE ieNewBrowserLauncher = this.ie.childBrowser();
        ChildBrowserTest.assertTrue((boolean)ieNewBrowserLauncher.containsText("Open New Browser Launcher"));
        this.ie.link(SymbolFactory.text, "New Window").click();
        IE ie_new = this.ie.childBrowser(1);
        ChildBrowserTest.assertTrue((boolean)ie_new.text().contains("PASS"));
        ChildBrowserTest.assertTrue((this.ie.childBrowserCount() == 2 ? 1 : 0) != 0);
        ieNewBrowserLauncher.link(SymbolFactory.text, "New Window").click();
        IE ieChild = ieNewBrowserLauncher.childBrowser();
        ChildBrowserTest.assertTrue((boolean)ieChild.text().contains("PASS"));
        ChildBrowserTest.assertTrue((ieNewBrowserLauncher.childBrowserCount() == 1 ? 1 : 0) != 0);
        ieNewBrowserLauncher.close();
        ie_new.close();
        ieChild.close();
        ChildBrowserTest.assertTrue((this.ie.childBrowserCount() == 0 ? 1 : 0) != 0);
        this.ie.goTo(HTML_ROOT + "textfields1.html");
        ChildBrowserTest.assertTrue((boolean)this.ie.textField(SymbolFactory.name, "text1").exists());
    }

    public void test_child_browser_slow_window_works_with_delay() throws Exception {
        this.ie.span(SymbolFactory.text, "New Window Slowly").click();
        IE ie_new = this.ie.childBrowser();
        ChildBrowserTest.assertTrue((boolean)ie_new.text().contains("Blank page to fill in the frames"));
        ie_new.close();
    }

    public void testSelfClosingSubWindows() throws Exception {
        for (int i = 0; i < 20; ++i) {
            this.ie.link(SymbolFactory.text, "Self Closer").click();
            ChildBrowserTest.assertEquals((int)1, (int)this.ie.childBrowserCount());
            IE childBrowser = this.ie.childBrowser();
            ChildBrowserTest.assertTrue((boolean)childBrowser.containsText("Self-closer"));
            ChildBrowserTest.assertTrue((boolean)childBrowser.exists());
            childBrowser.button("Close Window").click();
            childBrowser.waitUntilClosed();
            ChildBrowserTest.assertFalse((boolean)childBrowser.exists());
        }
    }
}

