package jp.sourceforge.cfneo.at4ie;

import jp.sourceforge.cfneo.at4ie.api.AT4IEFileContentsException;
import jp.sourceforge.cfneo.at4ie.api.AT4IEFileException;
import jp.sourceforge.cfneo.at4ie.api.impl.TestFactory;

import org.apache.log4j.Logger;


/**
 * AT4IE-Auto Test for Internet Explorer̃GgE|CgB
 * @author imaitakafumi
 *
 */
public class AT4IEMain {

	Logger logger = Logger.getLogger(AT4IEMain.class);

	/**
	 * R}hCNۂ̃GgE|CgB
	 * @param args
	 */
	public static void main(String[] args) {
		try {
			new AT4IEMain().run(args);
		} catch (AT4IEFileException e) {
			e.printStackTrace();
		} catch (AT4IEFileContentsException e) {
			e.printStackTrace();
		}
	}

	/**
	 * JavaNXNۂ̃GgE|CgB
	 * @param args
	 * @throws AT4IEFileException
	 * @throws AT4IEFileContentsException
	 */
	public void run(String[] args) throws AT4IEFileException, AT4IEFileContentsException {
		if ((args.length == 0) || (args[0] == null)) {
			throw new IllegalArgumentException("Input argument!");
		}
		logger.debug("AT4IEMain#run args=" + args[0]);
		TestFactory factory = new TestFactory(args[0]);
		factory.getTestRunner().doTest();
	}

}
