package jp.sourceforge.cfneo.at4ie.utils;

import static org.junit.Assert.assertEquals;
import jp.sourceforge.cfneo.at4ie.api.ElementLocatorEnum;

import org.junit.Test;

/**
 * LocatorUtilTest̃eXgB
 * @author imaitakafumi
 *
 */
public class LocatorUtilTest {

	/**
	 * getLocatorValuẽeXgB
	 * otheȑꍇB
	 */
	@Test
	public void testGetElementLocatorEnum_1_other() {
		ElementLocatorEnum en = LocatorUtil.getElementLocatorEnum("aaaaa");
		assertEquals(ElementLocatorEnum.OTHER, en);
	}
	/**
	 * getLocatorValuẽeXgB
	 * id̑IB
	 */
	@Test
	public void testGetElementLocatorEnum_2_id() {
		ElementLocatorEnum en = LocatorUtil.getElementLocatorEnum("id=\"aaa\"");
		assertEquals(ElementLocatorEnum.ID, en);
	}
	/**
	 * getLocatorValuẽeXgB
	 * namȇIB
	 */
	@Test
	public void testGetElementLocatorEnum_3_name() {
		ElementLocatorEnum en = LocatorUtil.getElementLocatorEnum("name=\"aaa\"");
		assertEquals(ElementLocatorEnum.NAME, en);
	}
	/**
	 * getLocatorValuẽeXgB
	 * valuȅꍇB
	 */
	@Test
	public void testGetElementLocatorEnum_4_value() {
		ElementLocatorEnum en = LocatorUtil.getElementLocatorEnum("value=\"aaa\"");
		assertEquals(ElementLocatorEnum.VALUE, en);
	}
	/**
	 * getLocatorValuẽeXgB
	 * dom̏ꍇB
	 */
	@Test
	public void testGetElementLocatorEnum_5_dom() {
		ElementLocatorEnum en = LocatorUtil.getElementLocatorEnum("dom=\"aaa\"");
		assertEquals(ElementLocatorEnum.DOM, en);
	}
	/**
	 * getLocatorValuẽeXgB
	 * xpath̏ꍇB
	 */
	@Test
	public void testGetElementLocatorEnum_6_xpath() {
		ElementLocatorEnum en = LocatorUtil.getElementLocatorEnum("xpath=\"aaa\"");
		assertEquals(ElementLocatorEnum.XPATH, en);
	}
	/**
	 * getLocatorValuẽeXgB
	 * link̏ꍇB
	 */
	@Test
	public void testGetElementLocatorEnum_7_link() {
		ElementLocatorEnum en = LocatorUtil.getElementLocatorEnum("link=../");
		assertEquals(ElementLocatorEnum.LINK, en);
	}
	/**
	 * getLocatorValuẽeXgB
	 * ُn:null
	 */
	@Test
	public void testGetElementLocatorEnum_8_null() {
		ElementLocatorEnum en = LocatorUtil.getElementLocatorEnum(null);
		assertEquals(null, en);
	}
	/**
	 * getLocatorValuẽeXgB
	 * ُn:""
	 */
	@Test
	public void testGetElementLocatorEnum_9_zerostring() {
		ElementLocatorEnum en = LocatorUtil.getElementLocatorEnum("");
		assertEquals(ElementLocatorEnum.OTHER, en);
	}

	/**
	 * getLocatorValuẽeXgB
	 * otheȑꍇB
	 */
	@Test
	public void testGetLocatorValue_1_other() {
		assertEquals("aaaaa",
				LocatorUtil.getLocatorValue("aaaaa"));
	}
	/**
	 * getLocatorValuẽeXgB
	 * id̏ꍇB
	 */
	@Test
	public void testGetLocatorValue_2_id() {
		assertEquals("aaa",
				LocatorUtil.getLocatorValue("id=\"aaa\""));
	}
	/**
	 * getLocatorValuẽeXgB
	 * namȅꍇB
	 */
	@Test
	public void testGetLocatorValue_3_name() {
		assertEquals("aaa",
				LocatorUtil.getLocatorValue("name=\"aaa\""));
	}
	/**
	 * getLocatorValuẽeXgB
	 * valuȅꍇB
	 */
	@Test
	public void testGetLocatorValue_4_value() {
		assertEquals("aaa",
				LocatorUtil.getLocatorValue("value=\"aaa\""));
	}
	/**
	 * getLocatorValuẽeXgB
	 * dom̏ꍇB
	 */
	@Test
	public void testGetLocatorValue_5_dom() {
		assertEquals("aaa",
				LocatorUtil.getLocatorValue("dom=\"aaa\""));
	}
	/**
	 * getLocatorValuẽeXgB
	 * xpath̏ꍇB
	 */
	@Test
	public void testGetLocatorValue_6_xpath() {
		assertEquals("aaa",
				LocatorUtil.getLocatorValue("xpath=\"aaa\""));
	}
	/**
	 * getLocatorValuẽeXgB
	 * link̏ꍇB
	 */
	@Test
	public void testGetLocatorValue_7_link() {
		assertEquals("aaa",
				LocatorUtil.getLocatorValue("link=\"aaa\""));
	}
	/**
	 * getLocatorValuẽeXgB
	 * ُn:null
	 */
	@Test
	public void testGetLocatorValue_8_null() {
		assertEquals(null,
				LocatorUtil.getLocatorValue(null));
	}
	/**
	 * getLocatorValuẽeXgB
	 * ُn:""
	 */
	@Test
	public void testGetLocatorValue_9_zerostring() {
		assertEquals("",
				LocatorUtil.getLocatorValue(""));
	}

	/**
	 * deleteDoubleQuotatioñeXgB
	 * _uENH[e[VȂB
	 */
	@Test
	public void testDeleteDoubleQuotation_1() {
		assertEquals("aaa",
				LocatorUtil.deleteDoubleQuotation("aaa"));
	}
	/**
	 * deleteDoubleQuotatioñeXgB
	 * _uENH[e[VB
	 */
	@Test
	public void testDeleteDoubleQuotation_2() {
		assertEquals("aaa",
				LocatorUtil.deleteDoubleQuotation("\"aaa\""));
	}
	/**
	 * deleteDoubleQuotatioñeXgB
	 * _uENH[e[V2ځB
	 */
	@Test
	public void testDeleteDoubleQuotation_3() {
		assertEquals("\"aaa\"",
				LocatorUtil.deleteDoubleQuotation("\"\"aaa\"\""));
	}
	/**
	 * deleteDoubleQuotatioñeXgB
	 * _uENH[e[VςB
	 */
	@Test
	public void testDeleteDoubleQuotation_4() {
		assertEquals("\"\"\"\"\"\"aaa\"\"\"\"\"\"",
				LocatorUtil.deleteDoubleQuotation("\"\"\"\"\"\"\"aaa\"\"\"\"\"\"\""));
	}
	/**
	 * deleteDoubleQuotatioñeXgB
	 * ُn:null
	 */
	@Test
	public void testDeleteDoubleQuotation_5() {
		assertEquals(null,
				LocatorUtil.deleteDoubleQuotation(null));
	}
	/**
	 * deleteDoubleQuotatioñeXgB
	 * ُn:""
	 */
	@Test
	public void testDeleteDoubleQuotation_6() {
		assertEquals("",
				LocatorUtil.deleteDoubleQuotation(""));
	}

}
/*
Element Locators

Element Locator Ƃ́ASelenium ɂāAR}hQƂhtml vf肷̂łBSelenium łElementLocator ƂĈȉ̕@񋟂Ă܂Bhtml ̗vfSʂɑ΂Ďg@łB
    * id
       	id=id l
      id Ŏw肳ꂽvfI܂B
    * name
       	name=name l
      name Ŏw肳ꂽvf̂Aŏɍv̂I܂B
    * identifier
       	identifier=id l܂name l
      id Ŏw肳ꂽvfIAid ōv̂Ȃname Ŏw肳ꂽvf̂ŏɍv̂I܂B
    * dom
       	dom=javascript \@
      HTML DocumentObjectModel(DOM)Javascript Traversal W[gėvf܂Bjavascript \@Ŏw肷DOM ̃P[^"document."Ŏn܂Ȃ΂Ȃ܂B
      ()
      dom=document.forms['myForm'].myDropdown
      dom=document.images[56]
    * xpath
       	xpath=xpath \
      XPath \gpėvf̏ꏊ肵܂BXPath \"//"Ŏn܂Ȃ΂Ȃ܂B
      ()
      xpath=//img[@alt='The image alt text']
      xpath=//table[@id='table1']//tr[4]/td[2]
    * link
       	link=N̕pattern
      w肳ꂽpattern ƍveLXg܂ރN(anchor)vfI܂B
      ()
      link=The link text
ElementLocator prefix("xxx=")ꍇASelenium ͈ȉ̂̂Ɖ߂ē삵܂B
"document."n܂Ăꍇ 	dom=Ɖ߂ē
"//"n܂Ăꍇ 	xpath=Ɖ߂ē
ȊO 	identifier=Ɖ߂ē 

via http://wiki.openqa.org/display/SEL/Command%20Reference%20ja
 */
