package jp.sourceforge.cfneo.at4ie2.api.browser.impl.ie;

import java.util.ArrayList;
import java.util.List;

import jp.sourceforge.cfneo.at4ie2.BTRuntimeError;
import jp.sourceforge.cfneo.at4ie2.api.browser.Option;
import jp.sourceforge.cfneo.at4ie2.api.browser.Select;
import watij.elements.Options;
import watij.elements.SelectList;
import watij.finders.SymbolFactory;

public class BTSelect implements Select {

	SelectList selectList;

	BTSelect(SelectList selectList) {
		this.selectList = selectList;
	}

	@Override
	public List<Option> getOptionList() {
		try {
			List<Option> optionList = new ArrayList<Option>();
			Options options = this.selectList.options();
			for (int i = 0; i < options.length(); i++) {
				watij.elements.Option option = (watij.elements.Option) options.get(i);
				optionList.add(new BTOption(option));
			}
			return optionList;
		} catch (Exception e) {
			throw new BTRuntimeError(e);
		}
	}
	@Override
	public String getId() {
		try {
			return this.selectList.id();
		} catch (Exception e) {
			throw new BTRuntimeError(e);
		}
	}
	@Override
	public String getName() {
		try {
			return this.selectList.name();
		} catch (Exception e) {
			throw new BTRuntimeError(e);
		}
	}
	@Override
	public String getValue() {
		return this.getSelectedOption().getId();
	}
	@Override
	public Option getOption(String id) {
		try {
			return new BTOption(this.selectList.option(SymbolFactory.id, id));
		} catch (Exception e) {
			throw new BTRuntimeError(e);
		}
	}
	@Override
	public Option getOptionByValue(String value) {
		try {
			return new BTOption(this.selectList.option(SymbolFactory.value, value));
		} catch (Exception e) {
			throw new BTRuntimeError(e);
		}
	}
	@Override
	public Option getOptionByName(String name) {
		try {
			return new BTOption(this.selectList.option(SymbolFactory.name, name));
		} catch (Exception e) {
			throw new BTRuntimeError(e);
		}
	}
	@Override
	public Option getOptionByLabel(String label) {
		try {
			return new BTOption(this.selectList.option(SymbolFactory.text, label));
		} catch (Exception e) {
			throw new BTRuntimeError(e);
		}
	}
	@Override
	public Option getSelectedOption() {
		try {
			return new BTOption(this.selectList.option(SymbolFactory.value, this.selectList.value()));
		} catch (Exception e) {
			throw new BTRuntimeError(e);
		}
	}
	@Override
	public boolean exists() {
		try {
			return this.selectList.exists();
		} catch (Exception e) {
			throw new BTRuntimeError(e);
		}
	}

}
