package jp.sourceforge.cfneo.at4ie2.api.test.impl.invoker;

import jp.sourceforge.cfneo.at4ie2.api.browser.TextField;
import jp.sourceforge.cfneo.at4ie2.api.test.AbstractInvoker;
import jp.sourceforge.cfneo.at4ie2.api.test.BTAssertException;
import jp.sourceforge.cfneo.at4ie2.api.test.Context;
import jp.sourceforge.cfneo.at4ie2.api.test.LocatorTypeEnum;
import jp.sourceforge.cfneo.at4ie2.api.test.TestCase;

public class AssertTextInvoker extends AbstractInvoker {

	public AssertTextInvoker(Context context) {
		super(context);
	}

	@Override
	public void invoke(TestCase testCase) {
		String expected = testCase.getValue();

		LocatorTypeEnum locatorType = testCase.getTarget().getLocatorType();
		TextField textField = null;
		switch (locatorType) {
		case DOM:
			break;
		case ID:
			textField = this.getBrowser().getTextField(testCase.getTarget().getValue());
			break;
		case IDENTIFIER:
			textField = this.getBrowser().getTextField(testCase.getTarget().getValue());
			if (textField.exists() == false) {
				textField = this.getBrowser().getTextFieldByName(testCase.getTarget().getValue());
			}
			break;
		case LINK:
			break;
		case NAME:
			textField = this.getBrowser().getTextFieldByName(testCase.getTarget().getValue());
			break;
		case OTHER:
			break;
		case VALUE:
			break;
		case XPATH:
			break;
		default:
			;
		}

		String actual = textField.getValue();
		if (expected.equals(actual) == false) {
			throw new BTAssertException(expected, actual);
		}
	}

}
