package jp.sourceforge.cfneo.at4ie2.api.test.impl.invoker;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import jp.sourceforge.cfneo.at4ie2.BTRuntimeError;
import jp.sourceforge.cfneo.at4ie2.api.test.AbstractInvoker;
import jp.sourceforge.cfneo.at4ie2.api.test.BTTestCaseInvalidExceptioin;
import jp.sourceforge.cfneo.at4ie2.api.test.Context;
import jp.sourceforge.cfneo.at4ie2.api.test.TestCase;
import jp.sourceforge.cfneo.at4ie2.api.test.TestCaseValidator;

public class PauseInvoker extends AbstractInvoker implements TestCaseValidator {

	public PauseInvoker(Context context) {
		super(context);
	}

	@Override
	public void invoke(TestCase testCase) {
		try {
			Thread.sleep(Long.parseLong(testCase.getTarget().getValue()));
		} catch (NumberFormatException e) {
			throw new BTTestCaseInvalidExceptioin(e);
		} catch (InterruptedException e) {
			throw new BTRuntimeError(e);
		}
	}
	@Override
	public void validate(TestCase testCase) {
		Pattern p = Pattern.compile("[^0-9]");
		Matcher m = p.matcher(testCase.getTarget().getValue());
		if (m.matches()) {
			throw new BTTestCaseInvalidExceptioin(
					"Locator value is invalid param.["
					+ testCase.getTarget().getValue() + "]");
		}
	}

}
