<cfcomponent output="false">

	<cffunction name="entryNew" access="public" output="false" returntype="void">
		<cfargument name="event_type_id" type="numeric" required="true" />
		<cfargument name="event_type_name" type="string" required="true" />
		<cftry>
			<cftransaction isolation="read_committed">
				<cfset THIS.comMgr.getComponent("master.event_type_master.facade.flow.EntryFlow")
						.doFlow(ARGUMENTS.event_type_id, ARGUMENTS.event_type_name) />
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback" />
				<cfrethrow />
			</cfcatch>
		</cftry>
	</cffunction>

	<cffunction name="remove" access="public" output="false" returntype="void">
		<cfargument name="event_type_id" type="numeric" required="true" />
		<cftry>
			<cftransaction isolation="read_committed">
				<cfset THIS.comMgr.getComponent("master.event_type_master.facade.flow.RemoveFlow")
						.doFlow(ARGUMENTS.event_type_id) />
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback" />
				<cfrethrow />
			</cfcatch>
		</cftry>
	</cffunction>

</cfcomponent>