<!---//
////////////////////////////////////////////////////////////////////////////////
//	Copyright 2008 cfneo-Project, jp.sourceforge.cfneo and the Others.
//
//	http://sourceforge.jp/projects/cfneo
//
//	Licensed under the Apache License, Version 2.0 (the "License");
//	you may not use this file except in compliance with the License.
//	You may obtain a copy of the License at
//
//	    http://www.apache.org/licenses/LICENSE-2.0
//
//	Unless required by applicable law or agreed to in writing, software
//	distributed under the License is distributed on an "AS IS" BASIS,
//	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
//	either express or implied. See the License for the specific language
//	governing permissions and limitations under the License.
////////////////////////////////////////////////////////////////////////////////
//--->
<cfcomponent output="false" extends="cfneo.appcore.cfneounit.ApplicationProxy">
	<cffunction name="text2StructArray" 
	      output="false"
	      returntype="array"
	      hint="\̂̔zɕϊ܂<br>1sڂvfƂAȍ~̍svfɑΉlƂĕϊ܂">
	  <cfargument name="text" type="string" required="true">
	  <cfargument name="delimiter" type="string" required="false" default=",">
	  <cfset var retArray=ArrayNew(1) />
	  <cfset var colArray="" />
	  <cfloop index="row" list="#Trim(ARGUMENTS.text)#" delimiters="#Chr(10)##Chr(13)#">
	    <cfif NOT IsArray(colArray) >
	      <cfset colArray=ArrayNew(1) />
	      <cfloop index="col" list="#Trim(row)#" delimiters="#ARGUMENTS.delimiter#">
	        <cfset ArrayAppend(colArray, Trim(col)) />
	      </cfloop>
	    <cfelse>
	      <cfset rowStruct=StructNew() />
	      <cfset loopIdx=0 />
	      <cfset rowstr=row />
	      <cfloop index="val" list="#Trim(rowstr)#" delimiters="#ARGUMENTS.delimiter#">
	        <cfset loopIdx=loopIdx+1 />
	        <cfif loopIdx LE ArrayLen(colArray) >
	          <cfset StructInsert(rowStruct, colArray[loopIdx], Trim(val)) />
	        <cfelse>
	          <cfthrow type="Application" 
	            errorcode="argument-Exception" 
	            message="rows doesn't agree with values." />
	        </cfif>
	      </cfloop>
	      <cfset ArrayAppend(retArray, rowStruct) />
	    </cfif>
	  </cfloop>
	  <cfreturn retArray />
	</cffunction>
</cfcomponent>
