<!---//
////////////////////////////////////////////////////////////////////////////////
//	Copyright 2008 cfneo-Project, jp.sourceforge.cfneo and the Others.
//
//	http://sourceforge.jp/projects/cfneo
//
//	Licensed under the Apache License, Version 2.0 (the "License");
//	you may not use this file except in compliance with the License.
//	You may obtain a copy of the License at
//
//	    http://www.apache.org/licenses/LICENSE-2.0
//
//	Unless required by applicable law or agreed to in writing, software
//	distributed under the License is distributed on an "AS IS" BASIS,
//	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
//	either express or implied. See the License for the specific language
//	governing permissions and limitations under the License.
////////////////////////////////////////////////////////////////////////////////
//--->
<?xml version="1.0" encoding="utf8"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
 "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja" lang="ja">
	<cfoutput>
		<cfset pageTitle="Test driver [appcore/utils/ComponentUtil.cfc]" />
		<head>
			<cfinclude template="#APPLICATION.ContentsRoot#/appcore/cfneounit/td_header.cfm" />
		</head>
		<body>
			<h1>#pageTitle#</h1>
			<cfset com=getComponentManager()
					.getComponent("appcore.utils.ComponentUtil") />
			<fieldset>
				<legend>getDataType</legend>
				<table>
					<tr>
						<th>caseNo</th>
						<th>note</th>
						<th>input</th>
						<th>expected</th>
						<th>actual</th>
						<th>result</th>
					</tr>
					<cfset caseNo=0 />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=getComponentManager().getComponent("dev.test.appcore.utils.ComponentUtil4Test") />
					<cfset exp="method" />
					<cfset act=com.getDataType(in["publicFunction1"]) />
					<cfset assert(caseNo, "\bh̃P[X", in, exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in="string" />
					<cfset exp="string" />
					<cfset act=com.getDataType(in) />
					<cfset assert(caseNo, "̃P[X", in, exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=" " />
					<cfset exp="string" />
					<cfset act=com.getDataType(in) />
					<cfset assert(caseNo, "̃P[X", in, exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in="" />
					<cfset exp="string" />
					<cfset act=com.getDataType(in) />
					<cfset assert(caseNo, "̃P[X", in, exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=Now() />
					<cfset exp="date" />
					<cfset act=com.getDataType(in) />
					<cfset assert(caseNo, "t̃P[X", in, exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=-1 />
					<cfset exp="numeric" />
					<cfset act=com.getDataType(in) />
					<cfset assert(caseNo, "l()̃P[X", in, exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=0 />
					<cfset exp="numeric" />
					<cfset act=com.getDataType(in) />
					<cfset assert(caseNo, "l()̃P[X", in, exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=12345 />
					<cfset exp="numeric" />
					<cfset act=com.getDataType(in) />
					<cfset assert(caseNo, "l()̃P[X", in, exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=1234.5 />
					<cfset exp="numeric" />
					<cfset act=com.getDataType(in) />
					<cfset assert(caseNo, "l(_)̃P[X", in, exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset exp="struct" />
					<cfset act=com.getDataType(in) />
					<cfset assert(caseNo, "\̂̃P[X", in, exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=ArrayNew(1) />
					<cfset exp="array" />
					<cfset act=com.getDataType(in) />
					<cfset assert(caseNo, "z̃P[X", in, exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=com />
					<cfset exp="object" />
					<cfset act=com.getDataType(in) />
					<cfset assert(caseNo, "CFR|[lg̃P[X", in, exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=true />
					<cfset exp="boolean" />
					<cfset act=com.getDataType(in) />
					<cfset assert(caseNo, "^Ul̃P[X", in, exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=false />
					<cfset exp="boolean" />
					<cfset act=com.getDataType(in) />
					<cfset assert(caseNo, "^Ul̃P[X", in, exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=QueryNew("col1,col2", "VarChar,VarChar") />
					<cfset QueryAddRow(in, 1) />
					<cfset QuerySetCell(in, "col1", "aaa", 1) />
					<cfset QuerySetCell(in, "col2", "bbb", 1) />
					<cfset exp="query" />
					<cfset act=com.getDataType(in) />
					<cfset assert(caseNo, "NG\̂̃P[X", in, exp, act) />
					
					<!--- savecontentŋLq --->
					<cfsavecontent variable="testPatternStr">
					title               | in                         | exp     
					lI        | 12345                      | numeric 
					lI        | 20080921                   | numeric 
					lI        | 1                          | numeric 
					lI        | 0                          | numeric 
					lI        | -1                         | numeric 
					lI        | 000000001                  | numeric 
					lI        | 0.0000001                  | numeric 
					^UlI      | true                       | boolean 
					^UlI      | false                      | boolean 
					tI        | 2008/09/21                 | date    
					tI        | 2008.09.21                 | date    
					              | 2008.02.30                 | string  
					              | 1,2,3,4,5                  | string  
					              | abcdefghijklmnopqrstuvwxyz | string  
					              | string                     | string  
					              | STRING                     | string  
					              | 1,0,0,0                    | string  
					              | 255.255.255.001            | string  
					              | }`oCg             | string  
					              | POOOOO                    | string  
					              | 2008N0921             | string  
					              | 0x1a                       | string  
					              | 999,999,999                | string  
					              | http://localhost/          | string  
					</cfsavecontent>
					<cfset testPattern=text2StructArray(testPatternStr,"|") />
					<cfloop index="idx" from="1" to="#ArrayLen(testPattern)#">
						<cfset caseNo=IncrementValue(caseNo) />
						<cfset pattern=testPattern[idx] />
						<cfset title=pattern.title />
						<cfset in=pattern.in />
						<cfset exp=pattern.exp />
						<cfset act=com.getDataType(pattern.in) />
						<cfset assert(caseNo, title, in, exp, act) />
					</cfloop>
					
				</table>
			</fieldset>
			<fieldset>
				<legend>getRealComponentName</legend>
				<table>
					<tr>
						<th>caseNo</th>
						<th>note</th>
						<th>input</th>
						<th>expected</th>
						<th>actual</th>
						<th>result</th>
					</tr>
					<cfset caseNo=0 />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in="appcore/ComponentManager" />
					<cfset exp="cfneo.appcore.ComponentManager" />
					<cfset act=com.getRealComponentName(in) />
					<cfset assert(caseNo, "[gpbP[Ww肵Ȃ", in, exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in="/appcore/ComponentManager" />
					<cfset exp="cfneo.appcore.ComponentManager" />
					<cfset act=com.getRealComponentName(in) />
					<cfset assert(caseNo, "[gpbP[Ww肵Ȃ", in, exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in="/cfneo/appcore/ComponentManager" />
					<cfset exp="cfneo.appcore.ComponentManager" />
					<cfset act=com.getRealComponentName(in) />
					<cfset assert(caseNo, "[gpbP[Ww肷", in, exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in="" />
					<cfset exp="cfneo." />
					<cfset act=com.getRealComponentName(in) />
					<cfset assert(caseNo, "󕶎w肷", in, exp, act) />

				</table>
			</fieldset>
			<fieldset>
				<legend>getMethodNameArray</legend>
				<table>
					<tr>
						<th>caseNo</th>
						<th>note</th>
						<th>input</th>
						<th>expected</th>
						<th>actual</th>
						<th>result</th>
					</tr>
					<cfset caseNo=0 />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in="appcore.ComponentManager" />
					<cfset exp=ArrayNew(1) />
					<cfset ArrayAppend(exp, "getComponent") />
					<cfset act=com.getMethodNameArray(in) />
					<cfset assert(caseNo, "invoke", in, exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in="dev.test.appcore.utils.ComponentUtil4Test" />
					<cfset exp=ArrayNew(1) />
					<cfset ArrayAppend(exp, "publicFunction1")>
					<cfset act=com.getMethodNameArray(in) />
					<cfset assert(caseNo, "invoke", in, exp, act) />
					
					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in="dev.test.appcore.utils.ComponentUtil4Test" />
					<cfset exp=ArrayNew(1) />
					<cfset ArrayAppend(exp, "publicFunction1")>
					<cfset act=com.getMethodNameArray(in) />
					<cfset dat=GetMetaData(act) />
					<cfset assert(caseNo, "invoke", in, exp, act) />
					
					
				</table>
			</fieldset>
		</body>
	</cfoutput>
</html>
