<!---//
////////////////////////////////////////////////////////////////////////////////
//	Copyright 2008 cfneo-Project, jp.sourceforge.cfneo and the Others.
//
//	http://sourceforge.jp/projects/cfneo
//
//	Licensed under the Apache License, Version 2.0 (the "License");
//	you may not use this file except in compliance with the License.
//	You may obtain a copy of the License at
//
//	    http://www.apache.org/licenses/LICENSE-2.0
//
//	Unless required by applicable law or agreed to in writing, software
//	distributed under the License is distributed on an "AS IS" BASIS,
//	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
//	either express or implied. See the License for the specific language
//	governing permissions and limitations under the License.
////////////////////////////////////////////////////////////////////////////////
//--->
<?xml version="1.0" encoding="utf8"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
 "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja" lang="ja">
	<cfoutput>
		<cfset pageTitle="Test driver [appcore/utils/FileUtilTest.cfc]" />
		<head>
			<cfinclude template="#APPLICATION.ContentsRoot#/appcore/cfneounit/td_header.cfm" />
		</head>
		<body>
			<h1>#pageTitle#</h1>
			<cfset com=getComponentManager().getComponent("appcore.utils.FileUtil") />
			<fieldset>
				<legend>tailRead</legend>
				<table>
					<tr>
						<th>caseNo</th>
						<th>note</th>
						<th>input</th>
						<th>expected</th>
						<th>actual</th>
						<th>result</th>
					</tr>
					<cfset caseNo=0 />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=ExpandPath("./FileUtil/in1.txt") />
					<cfset exp="5:fifth" />
					<cfset act=com.tailRead(in) />
					<cfset assert(caseNo, "n(sw薳)", in,
							exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=ExpandPath("./FileUtil/in1.txt") />
					<cfset exp="4:forth5:fifth" />
					<cfset act=com.tailRead(in, 2) />
					<cfset assert(caseNo, "n(swA)", in,
							exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=ExpandPath("./FileUtil/in3.txt") />
					<cfset exp="1:first" />
					<cfset act=com.tailRead(in) />
					<cfset assert(caseNo, "n(ŝ݂̃t@C)", in,
							exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=ExpandPath("./FileUtil/in3.txt") />
					<cfset exp="1:first" />
					<cfset act=com.tailRead(in) />
					<cfset assert(caseNo, "n(ŝ݂̃t@CŖ[ɉs)", in,
							exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=ExpandPath("./FileUtil/in1.txt") />
					<cfset exp="RegEx pattern un match.">
					<cftry>
						<cfset com.tailRead(in, 10) />
						<cfcatch>
							<cfset act=cfcatch.Message />
						</cfcatch>
					</cftry>
					<cfset assert(caseNo, "ُnFt@C̍s̍sw(10)",
							in, exp, act ) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=ExpandPath("./FileUtil/in1.txt") />
					<cfset exp="1:first2:second3:third4:forth5:fifth" />
					<cfset act=com.tailRead(in, 5) />
					<cfset assert(caseNo, "nFt@C̍sƓsw(5)",
							in, exp, act ) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=ExpandPath("./FileUtil/in1.txt") />
					<cfset exp="RegEx pattern un match." />
					<cftry>
						<cfset com.tailRead(in, 6) />
						<cfcatch>
							<cfset act=cfcatch.Message />
						</cfcatch>
					</cftry>
					<cfset assert(caseNo, "ُnFt@C̍sЂƂ̍sw(6)",
							in, exp, act ) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=ExpandPath("./FileUtil/in1.txt") />
					<cfset exp="2:second3:third4:forth5:fifth" />
					<cfset act=com.tailRead(in, 4) />
					<cfset assert(caseNo, "nFt@C̍sЂƂ̍sw(4)",
							in, exp, act ) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=ExpandPath("./FileUtil/in1.txt") />
					<cfset exp="rowcount is smaller than 1." />
					<cfset act="" />
					<cftry>
						<cfset com.tailRead(in, 0) />
						<cfcatch>
							<cfset act=cfcatch.Message />
						</cfcatch>
					</cftry>
					<cfset assert(caseNo, "ُn:sȍswiOj", in,
							exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=ExpandPath("./FileUtil/in1.txt") />
					<cfset exp="rowcount is smaller than 1." />
					<cfset act="" />
					<cftry>
						<cfset com.tailRead(in, -1) />
						<cfcatch>
							<cfset act=cfcatch.Message />
						</cfcatch>
					</cftry>
					<cfset assert(caseNo, "ُn:sȍswi-1j", in,
							exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=ExpandPath("./FileUtil/inxxx.txt") />
					<cfset exp="File[#in#] is not found." />
					<cfset act="" />
					<cftry>
						<cfset com.tailRead(in) />
						<cfcatch>
							<cfset act=cfcatch.Message />
						</cfcatch>
					</cftry>
					<cfset assert(caseNo, "ُn:݂ȂFilew", in,
							exp, act) />
				</table>
			</fieldset>
			<fieldset>
				<legend>createFileArray</legend>
				<table>
					<tr>
						<th>caseNo</th>
						<th>note</th>
						<th>input</th>
						<th>expected</th>
						<th>actual</th>
						<th>result</th>
					</tr>
					<cfset caseNo=0 />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=ExpandPath("#APPLICATION.ContentsRoot#/dev/test/appcore/utils/FileUtil/createFileArray/dir4") />
					<cfset exp=ArrayNew(1) />
					<cfset ArrayAppend(exp, "#APPLICATION.ContentsRoot#/dev/test/appcore/utils/FileUtil/createFileArray/dir4/file4.txt") />
					<cfset act=com.createFileArray(in) />
					<cfset assert(caseNo, "fBNgȂfBNgw", in, exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=ExpandPath("#APPLICATION.ContentsRoot#/dev/test/appcore/utils/FileUtil/createFileArray") />
					<cfset exp=ArrayNew(1) />
					<cfset ArrayAppend(exp, "#APPLICATION.ContentsRoot#/dev/test/appcore/utils/FileUtil/createFileArray/file1.txt") />
					<cfset ArrayAppend(exp, "#APPLICATION.ContentsRoot#/dev/test/appcore/utils/FileUtil/createFileArray/dir1/file2.txt") />
					<cfset ArrayAppend(exp, "#APPLICATION.ContentsRoot#/dev/test/appcore/utils/FileUtil/createFileArray/dir1/dir2/file3.txt") />
					<cfset ArrayAppend(exp, "#APPLICATION.ContentsRoot#/dev/test/appcore/utils/FileUtil/createFileArray/dir4/file4.txt") />
					<cfset act=com.createFileArray(in) />
					<cfset assert(caseNo, "fBNgfBNgw", in, exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=ExpandPath("#APPLICATION.ContentsRoot#/dev/test/appcore/utils/FileUtil/createFileArray/dir3") />
					<cfset exp=ArrayNew(1) />
					<cfset act=com.createFileArray(in) />
					<cfset assert(caseNo, "Ƀt@CȂfBNgw", in, exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset act="" />
					<cfset in=ExpandPath("#APPLICATION.ContentsRoot#/dev/test/appcore/utils/FileUtil/createFileArray/dirxxx") />
					<cfset exp="Directory:[#in#] is not found." />
					<cftry>
						<cfset com.createFileArray(in) />
						<cfcatch>
							<cfset act=cfcatch.Message />
						</cfcatch>
					</cftry>
					<cfset assert(caseNo, "݂ȂfBNgw", in, exp, act) />
				</table>
			</fieldset>
			<fieldset>
				<legend>createContentsArray</legend>
				<table>
					<tr>
						<th>caseNo</th>
						<th>note</th>
						<th>input</th>
						<th>expected</th>
						<th>actual</th>
						<th>result</th>
					</tr>
					<cfset caseNo=0 />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=ExpandPath("./FileUtil/in1.txt") />
					<cfset exp=ArrayNew(1) />
					<cfset ArrayAppend(exp, "1:first") />
					<cfset ArrayAppend(exp, "2:second") />
					<cfset ArrayAppend(exp, "3:third") />
					<cfset ArrayAppend(exp, "4:forth") />
					<cfset ArrayAppend(exp, "5:fifth") />
					<cfset act=com.createContentsArray(in) />
					<cfset assert(caseNo, "n:ĝt@C", in,
							exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=ExpandPath("./FileUtil/in5.txt") />
					<cfset exp=ArrayNew(1) />
					<cfset ArrayAppend(exp, "1:first") />
					<cfset ArrayAppend(exp, "2:second") />
					<cfset ArrayAppend(exp, "3:third") />
					<cfset ArrayAppend(exp, "4:forth") />
					<cfset ArrayAppend(exp, "5:fifth") />
					<cfset act=com.createContentsArray(in) />
					<cfset assert(caseNo, "n:ĝt@C(sR[hLF)", in,
							exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=ExpandPath("./FileUtil/in2.txt") />
					<cfset exp=ArrayNew(1) />
					<cfset act=com.createContentsArray(in) />
					<cfset assert(caseNo, "n:t@C", in,
							exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=ExpandPath("./FileUtil/in3.txt") />
					<cfset exp=ArrayNew(1) />
					<cfset ArrayAppend(exp, "1:first") />
					<cfset act=com.createContentsArray(in) />
					<cfset assert(caseNo, "n:ĝt@C(1ŝ)", in,
							exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=ExpandPath("./FileUtil/inxxx.txt") />
					<cfset exp="File[#in#] is not found." />
					<cftry>
						<cfset com.createContentsArray(in) />
						<cfcatch>
							<cfset act=cfcatch.Message />
						</cfcatch>
					</cftry>
					<cfset assert(caseNo, "ُn:݂ȂFilew",
							in, exp, act) />

				</table>
			</fieldset>
			<fieldset>
				<legend>createNewFile</legend>
				<table>
					<tr>
						<th>caseNo</th>
						<th>note</th>
						<th>input</th>
						<th>expected</th>
						<th>actual</th>
						<th>result</th>
					</tr>
					<cfset caseNo=0 />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=ExpandPath("./FileUtil/in_createNewFile_1_#DateFormat(Now(), 'YYMMDD')##TimeFormat(Now(), 'HHMMSS')#.txt") />
					<cfset com.createNewFile(in) />
					<cfset assert(caseNo, "n", in,
							true, FileExists(in)) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset uniquekey="#DateFormat(Now(), 'YYMMDD')##TimeFormat(Now(), 'HHMMSS')#" />
					<cfset in=ExpandPath("./FileUtil/temp2/temp_#uniquekey#/in_createNewFile_2_#uniquekey#.txt") />
					<cfset com.createNewFile(in) />
					<cfset assert(caseNo, "n:݂ȂfBNg-1", in,
							true, FileExists(in)) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset uniquekey="#DateFormat(Now(), 'YYMMDD')##TimeFormat(Now(), 'HHMMSS')#" />
					<cfset in=ExpandPath("./FileUtil/temp2/temp_#uniquekey#/in_createNewFile_2_#uniquekey#.txt") />
					<cfset com.createNewFile(in) />
					<cfset assert(caseNo, "n:݂ȂfBNg-2", in,
							true, FileExists(in)) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset uniquekey="#DateFormat(Now(), 'YYMMDD')##TimeFormat(Now(), 'HHMMSS')#" />
					<cfset in=ExpandPath("./FileUtil/temp2/in_createNewFile_3_#uniquekey#.txt/in_createNewFile_3_#uniquekey#.txt") />
					<cfset com.createNewFile(in) />
					<cfset assert(caseNo, "n:fBNgɃt@CƓ񂪊܂܂", in,
							true, FileExists(in)) />
				</table>
			</fieldset>
			<fieldset>
				<legend>updateFile</legend>
				<table>
					<tr>
						<th>caseNo</th>
						<th>note</th>
						<th>input</th>
						<th>expected</th>
						<th>actual</th>
						<th>result</th>
					</tr>
					<cfset caseNo=0 />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in.filepath=ExpandPath("./FileUtil/updateFile/text.txt") />
					<cfset in.output="1#Chr(10)#2#Chr(10)#3#Chr(10)#4#Chr(10)#5" />
					<cfset com.updateFile(in.filepath, in.output) />
					<cfset exp="" />
					<cfset act="" />
					<cffile action="read" file="#ExpandPath('./FileUtil/updateFile/expected_text1.txt')#" variable="exp" />
					<cffile action="read" file="#in.filepath#" variable="act" />
					<cfset assert(caseNo, "", in, exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in.filepath=ExpandPath("./FileUtil/updateFile/text.txt") />
					<cfset in.output="" />
					<cfset com.updateFile(in.filepath, in.output) />
					<cfset exp="" />
					<cfset act="" />
					<cffile action="read" file="#ExpandPath('./FileUtil/updateFile/expected_text2.txt')#" variable="exp" />
					<cffile action="read" file="#in.filepath#" variable="act" />
					<cfset assert(caseNo, "", in, exp, act) />
				</table>
			</fieldset>
		</body>
	</cfoutput>
</html>
