<!---//
////////////////////////////////////////////////////////////////////////////////
//	Copyright 2008 cfneo-Project, jp.sourceforge.cfneo and the Others.
//
//	http://sourceforge.jp/projects/cfneo
//
//	Licensed under the Apache License, Version 2.0 (the "License");
//	you may not use this file except in compliance with the License.
//	You may obtain a copy of the License at
//
//	    http://www.apache.org/licenses/LICENSE-2.0
//
//	Unless required by applicable law or agreed to in writing, software
//	distributed under the License is distributed on an "AS IS" BASIS,
//	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
//	either express or implied. See the License for the specific language
//	governing permissions and limitations under the License.
////////////////////////////////////////////////////////////////////////////////
//--->
<cfcomponent output="false">

	<cfset THIS.filepath="/#APPLICATION.ApplicationName#/examples/tw/dao/files/status.txt" />

	<cffunction name="selectAll" access="public" output="false" returntype="array">
		<cfset var list=THIS.comMgr.getComponent("appcore.utils.FileUtil")
				.createContentsArray(ExpandPath(THIS.filepath)) />
		<cfset var newlist=ArrayNew(1) />
		<cfset var idx="" />
		<cfset var s="" />
		<cfloop index="idx" from="1" to="#ArrayLen(list)#">
			<cfif Len(Trim(idx)) gt 0>
				<cfset s=StructNew() />
				<cfset s.user=ListGetAt(list[idx], 1) />
				<cfset s.status=ListGetAt(list[idx], 2) />
				<cfset ArrayAppend(newlist, s) />
			</cfif>
		</cfloop>
		<cfreturn newlist />
	</cffunction>

	<cffunction name="addStatus" access="public" output="false" returntype="void">
		<cfargument name="uid" type="string" required="true" />
		<cfargument name="newStatus" type="string" required="true" />
		<cfset var outputstatus=" " />
		<cfif Len(ARGUMENTS.newStatus) gt 0>
			<cfset outputstatus=ARGUMENTS.newStatus />
		</cfif>
		<cflock scope="application" type="exclusive" throwontimeout="true" timeout="0">
			<cffile action="append" addnewline="true" file="#ExpandPath(THIS.filepath)#"
					output="#ARGUMENTS.uid#,#outputstatus#" />
		</cflock>
	</cffunction>

</cfcomponent>