<!---//
////////////////////////////////////////////////////////////////////////////////
//	Copyright 2008 cfneo-Project, jp.sourceforge.cfneo and the Others.
//
//	http://sourceforge.jp/projects/cfneo
//
//	Licensed under the Apache License, Version 2.0 (the "License");
//	you may not use this file except in compliance with the License.
//	You may obtain a copy of the License at
//
//	    http://www.apache.org/licenses/LICENSE-2.0
//
//	Unless required by applicable law or agreed to in writing, software
//	distributed under the License is distributed on an "AS IS" BASIS,
//	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
//	either express or implied. See the License for the specific language
//	governing permissions and limitations under the License.
////////////////////////////////////////////////////////////////////////////////
//--->
<cfcomponent output="false">

	<cfset THIS.filepath="/#APPLICATION.ApplicationName#/examples/tw/dao/files/user.txt" />

	<cffunction name="selectAll" access="public" output="false" returntype="array">
		<cfset var list=THIS.comMgr.getComponent("appcore.utils.FileUtil")
				.createContentsArray(ExpandPath(THIS.filepath)) />
		<cfreturn list />
	</cffunction>

	<cffunction name="isExistsUser" access="public" output="false" returntype="boolean">
		<cfargument name="uid" type="string" required="true" />
		<cfset var list=selectAll() />
		<cfset var idx="" />
		<cfloop index="idx" list="#ArrayToList(list)#">
			<cfif ARGUMENTS.uid is idx>
				<cfreturn true />
			</cfif>
		</cfloop>
		<cfreturn false />
	</cffunction>

	<cffunction name="addUser" access="public" output="false" returntype="void">
		<cfargument name="uid" type="string" required="true" />
		<cfif Len(Trim(ARGUMENTS.uid)) is 0>
			<cfreturn />
		</cfif>
		<cflock scope="application" type="exclusive" throwontimeout="true" timeout="0">
			<cffile action="append" addnewline="true" file="#ExpandPath(THIS.filepath)#"
					output="#ARGUMENTS.uid#" />
		</cflock>
	</cffunction>

</cfcomponent>
