/*
 * Decompiled with CFR 0.152.
 */
package watij;

import watij.WatijTestCase;
import watij.elements.Frame;
import watij.finders.SymbolFactory;
import watij.runtime.UnknownObjectException;

public class FrameTest
extends WatijTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        ie.goTo(HTML_ROOT + "frame_buttons.html");
    }

    public void testFrameNoWhat() throws Exception {
        try {
            ie.frame("missingFrame").button(SymbolFactory.id, "b2");
            this.failUnknownObjectException();
        }
        catch (UnknownObjectException unknownObjectException) {
            // empty catch block
        }
        this.assertRaisesUnknownObjectExceptionForMethodEnabled(ie.frame("buttonFrame2").button(SymbolFactory.id, "b2"));
        FrameTest.assertTrue((boolean)ie.frame("buttonFrame").button(SymbolFactory.id, "b2").enabled());
        FrameTest.assertFalse((boolean)ie.frame("buttonFrame").button(SymbolFactory.caption, "Disabled Button").enabled());
    }

    public void testFrameTitle() throws Exception {
        FrameTest.assertEquals((String)"Test page for buttons", (String)ie.frame("buttonFrame").title());
    }

    public void testFrameUsingName() throws Exception {
        try {
            ie.frame(SymbolFactory.name, "missingFrame").button(SymbolFactory.id, "b2");
            this.failUnknownObjectException();
        }
        catch (UnknownObjectException unknownObjectException) {
            // empty catch block
        }
        this.assertRaisesUnknownObjectExceptionForMethodEnabled(ie.frame(SymbolFactory.name, "buttonFrame2").button(SymbolFactory.id, "b2"));
        FrameTest.assertTrue((boolean)ie.frame(SymbolFactory.name, "buttonFrame").button(SymbolFactory.id, "b2").enabled());
        FrameTest.assertFalse((boolean)ie.frame(SymbolFactory.name, "buttonFrame").button(SymbolFactory.caption, "Disabled Button").enabled());
    }

    public void testFrameUsingNameAndRegexp() throws Exception {
        try {
            ie.frame(SymbolFactory.name, "/missingFrame/").button(SymbolFactory.id, "b2");
            this.failUnknownObjectException();
        }
        catch (UnknownObjectException unknownObjectException) {
            // empty catch block
        }
        FrameTest.assertTrue((boolean)ie.frame(SymbolFactory.name, "/button/").button(SymbolFactory.id, "b2").enabled());
    }

    public void testFrameUsingIndex() throws Exception {
        try {
            ie.frame(8).button(SymbolFactory.id, "b2");
            this.failUnknownObjectException();
        }
        catch (UnknownObjectException unknownObjectException) {
            // empty catch block
        }
        this.assertRaisesUnknownObjectExceptionForMethodEnabled(ie.frame(1).button(SymbolFactory.id, "b2"));
        FrameTest.assertTrue((boolean)ie.frame(0).button(SymbolFactory.id, "b2").enabled());
        FrameTest.assertFalse((boolean)ie.frame(0).button(SymbolFactory.caption, "Disabled Button").enabled());
    }

    public void testFrameContainsText() throws Exception {
        Frame frame = ie.frame(SymbolFactory.name, "buttonFrame");
        FrameTest.assertTrue((boolean)frame.containsText("The top button is for testing buttons"));
    }
}

