/*
 * Decompiled with CFR 0.152.
 */
package watij.jniwrapper;

import com.jniwrapper.win32.ie.IEAutomation;
import com.jniwrapper.win32.ie.WebBrowser;
import com.jniwrapper.win32.ie.dom.HTMLElement;
import com.jniwrapper.win32.ie.dom.OptionElement;
import com.jniwrapper.win32.ie.dom.SelectElement;
import com.jniwrapper.win32.ie.event.NavigationEventListener;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.w3c.dom.NodeList;

public class VistaTeamDevTest
extends TestCase {
    private IEAutomation webBrowser;
    private IEListener listener;

    public void testLinkWaitReady() {
        try {
            new ConditionRunner(10000L, 200L).waitUntil(new Condition(){

                public boolean isSatisfied() {
                    try {
                        VistaTeamDevTest.this.webBrowser = new IEAutomation();
                        return true;
                    }
                    catch (Throwable t) {
                        System.err.println(t.getMessage());
                        return false;
                    }
                }
            });
            this.listener = new IEListener();
            this.webBrowser.addNavigationListener((NavigationEventListener)this.listener);
            this.webBrowser.setVisible(true);
            this.listener.setNavigationCompleted(false);
            this.webBrowser.navigate("http://www.google.com/");
            new ConditionRunner(180000L, 200L).waitUntil(new Condition(){

                public boolean isSatisfied() {
                    return VistaTeamDevTest.this.listener.isNavigationCompleted();
                }
            });
            this.webBrowser.waitReady();
            this.webBrowser.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            VistaTeamDevTest.fail((String)"Should not have thrown an exception");
        }
    }

    private SelectElement findSelectListByName(String name) {
        NodeList list = this.webBrowser.getDocument().getElementsByTagName("select");
        for (int i = 0; i < list.getLength(); ++i) {
            SelectElement l = (SelectElement)list.item(i);
            if (!name.equals(l.getAttribute("name"))) continue;
            return l;
        }
        throw new RuntimeException("Can't find select list with name " + name);
    }

    public void selectItem(SelectElement elem, String item) throws Exception {
        List optionsArray = elem.getOptions();
        for (OptionElement optionElement : optionsArray) {
            if (!item.equals(optionElement.getText())) continue;
            optionElement.select();
            return;
        }
        throw new RuntimeException("No option with text of " + item + " in this select element");
    }

    private HTMLElement findButtonByValue(String value) {
        NodeList list = this.webBrowser.getDocument().getElementsByTagName("input");
        for (int i = 0; i < list.getLength(); ++i) {
            HTMLElement elem = (HTMLElement)list.item(i);
            if (!"button".equals(elem.getAttribute("type")) || !value.equals(elem.getAttribute("value"))) continue;
            return elem;
        }
        throw new RuntimeException("Can't find button with value " + value);
    }

    private HTMLElement findLeftPanel() {
        List frames = this.webBrowser.getDocument().getFrames();
        for (HTMLElement frame : frames) {
            if (!"left_panel".equals(frame.getAttribute("name"))) continue;
            return frame;
        }
        throw new RuntimeException("Can't find left panel frame");
    }

    private HTMLElement findLogoutLink() {
        HTMLElement leftPanel = this.findLeftPanel();
        NodeList list = leftPanel.getElementsByTagName("A");
        for (int i = 0; i < list.getLength(); ++i) {
            HTMLElement elem = (HTMLElement)list.item(i);
            String url = elem.getAttribute("href");
            if (url == null || !url.contains("logout()")) continue;
            return elem;
        }
        throw new RuntimeException("Can't find logout link");
    }

    public static void main(String[] args) {
        TestRunner.run((Test)VistaTeamDevTest.suite());
    }

    public static Test suite() {
        return new TestSuite(VistaTeamDevTest.class);
    }

    public static class IEListener
    implements NavigationEventListener {
        private boolean navigationCompleted;

        public void setNavigationCompleted(boolean navigationCompleted) {
            this.navigationCompleted = navigationCompleted;
        }

        public boolean isNavigationCompleted() {
            return this.navigationCompleted;
        }

        public void downloadBegin() {
        }

        public void downloadCompleted() {
        }

        public void documentCompleted(WebBrowser webBrowser, String string) {
        }

        public void entireDocumentCompleted(WebBrowser webBrowser, String string) {
        }

        public void navigationCompleted(WebBrowser webBrowser, String string) {
            this.navigationCompleted = true;
        }

        public void progressChanged(int i, int i1) {
        }
    }

    public static class ConditionRunner {
        private long timeout;
        private long waitIncrement;

        public ConditionRunner(long timeout, long waitIncrement) {
            this.timeout = timeout;
            this.waitIncrement = waitIncrement;
        }

        public void waitUntil(Condition cond) throws Exception {
            long started = System.currentTimeMillis();
            while (!cond.isSatisfied()) {
                if (System.currentTimeMillis() - started > this.timeout) {
                    throw new RuntimeException("Timeout exceeded");
                }
                try {
                    Thread.sleep(this.waitIncrement);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static interface Condition {
        public boolean isSatisfied();
    }
}

