/*
 * Decompiled with CFR 0.152.
 */
package watij.runtime.ie;

import com.jniwrapper.win32.automation.OleMessageLoop;
import com.jniwrapper.win32.com.IUnknown;
import com.jniwrapper.win32.ie.dom.HTMLDocument;
import com.jniwrapper.win32.ie.dom.HTMLElement;
import com.jniwrapper.win32.mshtml.IHTMLElement;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.html.HTMLCollection;
import watij.elements.HtmlElement;
import watij.runtime.ObjectDisabledException;
import watij.runtime.UnknownObjectException;
import watij.runtime.ie.IE;
import watij.runtime.ie.IEContainer;
import watij.utilities.Debug;
import watij.utilities.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IEHtmlElement
extends IEContainer
implements HtmlElement {
    Element element;
    IE ie;

    public IEHtmlElement(Element element, IE ie) throws Exception {
        this.element = element;
        this.ie = ie;
    }

    @Override
    public Element element() throws Exception {
        return this.element;
    }

    protected HTMLElement htmlElement() throws Exception {
        return this.find(this.element);
    }

    @Override
    protected IE ie() throws Exception {
        return this.ie;
    }

    @Override
    protected HTMLDocument htmlDocument() throws Exception {
        return this.ie.htmlDocument();
    }

    @Override
    protected OleMessageLoop oleMessageLoop() {
        return this.ie.oleMessageLoop();
    }

    @Override
    public boolean disabled() throws Exception {
        String disabled = this.htmlElement().getAttribute("disabled");
        return Boolean.valueOf(disabled);
    }

    @Override
    public String id() throws Exception {
        return this.htmlElement().getAttribute("id");
    }

    @Override
    public String name() throws Exception {
        return this.htmlElement().getAttribute("name");
    }

    @Override
    public String title() throws Exception {
        return this.htmlElement().getAttribute("title");
    }

    @Override
    public String className() throws Exception {
        return this.htmlElement().getElementClass();
    }

    @Override
    public String type() throws Exception {
        return this.htmlElement().getAttribute("type");
    }

    @Override
    public String value() throws Exception {
        return this.htmlElement().getAttribute("value");
    }

    @Override
    public String style() throws Exception {
        return this.htmlElement().getBorder().getValue();
    }

    @Override
    public void click() throws Exception {
        this.assertEnabled();
        this.click(this.htmlElement());
    }

    protected void assertEnabled() throws Exception {
        if (this.disabled()) {
            throw new ObjectDisabledException();
        }
    }

    public String get() throws Exception {
        return this.innerText();
    }

    @Override
    public String text() throws Exception {
        return this.innerText();
    }

    @Override
    public String innerText() throws Exception {
        return this.htmlElement().getText();
    }

    public String tag() throws Exception {
        return this.htmlElement().getTagName();
    }

    private void click(HTMLElement htmlElement) throws Exception {
        try {
            htmlElement.click();
        }
        catch (Throwable t) {
            this.debug("WARNING ON CLICK:" + t.getMessage());
        }
    }

    @Override
    public void dblClick() throws Exception {
        this.dblClick(this.htmlElement());
    }

    private void dblClick(HTMLElement htmlElement) throws Exception {
        this.fireEvent(htmlElement, "ONDBLCLICK");
    }

    protected HTMLElement find(Element element) throws Exception {
        return this.find(element, this.htmlDocument());
    }

    protected HTMLElement find(Element element, HTMLDocument htmlDocument) throws Exception {
        if (element == null) {
            throw new UnknownObjectException();
        }
        NodeList nodeList = htmlDocument.getElementsByTagName(this.filterTagNameForIEBehaviors(element));
        int i = this.getByTagNameIndexForElement(element);
        return (HTMLElement)nodeList.item(i);
    }

    protected List<Element> toList(HTMLCollection htmlCollection) {
        ArrayList<Element> list = new ArrayList<Element>();
        for (int i = 0; i < htmlCollection.getLength(); ++i) {
            list.add((Element)htmlCollection.item(i));
        }
        return list;
    }

    private String filterTagNameForIEBehaviors(Element element) {
        String tagName = element.getTagName();
        int semiColonIndex = tagName.indexOf(":");
        if (semiColonIndex != -1) {
            tagName = tagName.substring(semiColonIndex + 1);
        }
        return tagName;
    }

    private int getByTagNameIndexForElement(Element element) {
        NodeList nodeList = element.getOwnerDocument().getElementsByTagName(element.getTagName());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!nodeList.item(i).equals(element)) continue;
            return i;
        }
        return -1;
    }

    protected void fireBeforeSetEvents(HTMLElement htmlElement) throws Exception {
        this.fireEvent(htmlElement, "ONSELECT");
    }

    protected void fireAfterSetEvents(HTMLElement htmlElement) throws Exception {
        this.fireEvent(htmlElement, "ONKEYPRESS");
        this.fireEvent(htmlElement, "ONKEYDOWN");
        this.fireEvent(htmlElement, "ONKEYUP");
        this.fireEvent(htmlElement, "ONCHANGE");
        this.fireEvent(htmlElement, "ONBLUR");
    }

    @Override
    public void fireEvent(String eventName) throws Exception {
        this.assertEnabled();
        this.fireEvent(this.htmlElement(), eventName);
    }

    private void fireEvent(HTMLElement htmlElement, String eventName) throws Exception {
        try {
            htmlElement.fireEvent(eventName);
        }
        catch (Throwable t) {
            this.debug("WARNING ON FIRE EVENT:" + t.getMessage());
        }
    }

    @Override
    public boolean enabled() throws Exception {
        return !this.disabled();
    }

    @Override
    public boolean exists() throws Exception {
        if (!this.ie().exists()) {
            return false;
        }
        try {
            return this.htmlElement() != null;
        }
        catch (Exception e) {
            Debug.handleException(e);
            return false;
        }
    }

    @Override
    public void focus() throws Exception {
        this.htmlElement().focus();
    }

    @Override
    public Object getOLEObject() throws Exception {
        return this.htmlElement().getElementPeer();
    }

    @Override
    public String html() throws Exception {
        IHTMLElement ihtmlElement = (IHTMLElement)this.oleMessageLoop().bindObject((IUnknown)this.htmlElement().getElementPeer());
        return ihtmlElement.getOuterHTML().getValue();
    }

    @Override
    public void flash() throws Exception {
        HTMLElement htmlElement = this.htmlElement();
        for (int i = 0; i < 10; ++i) {
            this.toggleColor(htmlElement);
        }
    }

    private void toggleColor(HTMLElement htmlElement) throws Exception {
        String originalColor = htmlElement.getStyle("background");
        htmlElement.setStyle("background", "yellow");
        Thread.sleep(50L);
        htmlElement.setStyle("background", "blue");
        Thread.sleep(50L);
        if (Utils.isEmpty(originalColor)) {
            htmlElement.setStyle("background", "transparent");
        } else {
            htmlElement.setStyle("background", originalColor);
        }
    }

    @Override
    public void show() throws Exception {
        System.out.println(this.toString());
    }

    public String toString() {
        Debug.getInstance().println("Begin IEHtmlElement.toString()");
        try {
            StringBuffer s = new StringBuffer();
            s.append("\n");
            s.append("{");
            s.append("\n");
            s.append("\t\"").append(this.tag()).append("\": {");
            this.readAttributesFromBrowser(s);
            s.deleteCharAt(s.length() - 1);
            s.append("\n");
            s.append("\t}");
            s.append("\n");
            s.append("}");
            Debug.getInstance().println("End IEHtmlElement.toString()");
            return s.toString();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    private void readAttributesFromBrowser(StringBuffer s) throws Exception {
        Debug.getInstance().println("Begin IEHtmlElement.readAttributesFromBrowser(StringBuffer s)");
        NamedNodeMap attrMap = this.htmlElement().getAttributes();
        Debug.getInstance().println("attrMap.getLength()= " + attrMap.getLength());
        this.readAttributes(attrMap, s);
        Debug.getInstance().println("End IEHtmlElement.readAttributesFromBrowser(StringBuffer s)");
    }

    private void readAttributesFromCache(StringBuffer s) throws Exception {
        NamedNodeMap attrMap = this.element().getAttributes();
        this.readAttributes(attrMap, s);
    }

    private void readAttributes(NamedNodeMap attrMap, StringBuffer s) {
        Debug.getInstance().println("Begin IEHtmlElement.readAttributes(NamedNodeMap attrMap, StringBuffer s)");
        int count = attrMap.getLength();
        for (int i = 0; i < count; ++i) {
            Attr attribute = (Attr)attrMap.item(i);
            if (!attribute.getSpecified() && !"value".equalsIgnoreCase(attribute.getName()) && !"type".equalsIgnoreCase(attribute.getName())) continue;
            s.append("\n");
            s.append("\t\t\"").append(attribute.getName()).append("\": ");
            s.append("\"");
            try {
                s.append(attribute.getValue());
            }
            catch (Exception e) {
                // empty catch block
            }
            s.append("\"");
            s.append(",");
        }
        Debug.getInstance().println("End IEHtmlElement.readAttributes(NamedNodeMap attrMap, StringBuffer s)");
    }
}

