/*
 * Decompiled with CFR 0.152.
 */
package watij.utilities;

import watij.utilities.FileOutput;
import watij.utilities.Output;

public class Debug
implements Output {
    private static boolean debug = Boolean.valueOf(System.getProperty("debug"));
    private Output output;

    public Debug(Output output) {
        this.output = output;
    }

    public void println(String string) {
        if (debug) {
            this.output.println(string);
        }
    }

    public static boolean isDebug() {
        return debug;
    }

    public static void setDebug(boolean debug) {
        Debug.debug = debug;
    }

    public static void handleException(Throwable throwable) {
        if (Debug.isDebug()) {
            System.out.println("Debug handled the following stack trace:");
            throwable.printStackTrace();
        }
    }

    public static Debug getInstance() {
        return new Debug(new Output(){

            public void println(String string) {
                System.out.println(string);
            }
        });
    }

    public static Debug getInstance(String fileName) {
        try {
            return new Debug(new FileOutput(fileName));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void deleteInstance(String fileName) {
        try {
            new FileOutput(fileName).delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

