/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.ie.dom;

import org.w3c.dom.Element;

public class ElementTypes {
    public static final String TAG_HEAD = "head";
    public static final String TAG_BODY = "body";
    public static final String TAG_LINK = "a";
    public static final String TAG_IMAGE = "img";
    public static final String TAG_DIV = "div";
    public static final String TAG_TABLE = "table";
    public static final String TAG_FORM = "form";
    public static final String TAG_INPUT = "input";
    public static final String TAG_TEXT_FIELD = "input";
    public static final String TAG_PASSWORD_FIELD = "input";
    public static final String TAG_CHECKBOX = "input";
    public static final String TAG_RADIO_BUTTON = "input";
    public static final String TAG_FILE_UPLOAD = "input";
    public static final String TAG_SUBMIT = "input";
    public static final String TYPE_TEXT_FIELD = "text";
    public static final String TYPE_PASSWORD_FIELD = "password";
    public static final String TYPE_CHECKBOX = "checkbox";
    public static final String TYPE_RADIO_BUTTON = "radio";
    public static final String TYPE_FILE_UPLOAD = "file";
    public static final String TYPE_BUTTON = "button";
    public static final String TYPE_SUBMIT = "submit";
    public static final String TAG_BUTTON = "button";
    public static final String TAG_TEXT_AREA = "textarea";
    public static final String TAG_SELECT = "select";
    public static final String TAG_SELECT_OPTION = "option";

    public static boolean isHead(Element element) {
        return ElementTypes.isElementWithTag(element, TAG_HEAD);
    }

    public static boolean isBody(Element element) {
        return ElementTypes.isElementWithTag(element, TAG_BODY);
    }

    public static boolean isLink(Element element) {
        return ElementTypes.isElementWithTag(element, TAG_LINK);
    }

    public static boolean isImage(Element element) {
        return ElementTypes.isElementWithTag(element, TAG_IMAGE);
    }

    public static boolean isDiv(Element element) {
        return ElementTypes.isElementWithTag(element, TAG_DIV);
    }

    public static boolean isTable(Element element) {
        return ElementTypes.isElementWithTag(element, TAG_TABLE);
    }

    public static boolean isForm(Element element) {
        return ElementTypes.isElementWithTag(element, TAG_FORM);
    }

    public static boolean isTextField(Element element) {
        return ElementTypes.isElementWithTag(element, "input") && ElementTypes.isElementWithType(element, TYPE_TEXT_FIELD);
    }

    public static boolean isTextArea(Element element) {
        return ElementTypes.isElementWithTag(element, TAG_TEXT_AREA);
    }

    public static boolean isPasswordField(Element element) {
        return ElementTypes.isElementWithTag(element, "input") && ElementTypes.isElementWithType(element, TYPE_PASSWORD_FIELD);
    }

    public static boolean isCheckbox(Element element) {
        return ElementTypes.isElementWithTag(element, "input") && ElementTypes.isElementWithType(element, TYPE_CHECKBOX);
    }

    public static boolean isRadioButton(Element element) {
        return ElementTypes.isElementWithTag(element, "input") && ElementTypes.isElementWithType(element, TYPE_RADIO_BUTTON);
    }

    public static boolean isSelect(Element element) {
        return ElementTypes.isElementWithTag(element, TAG_SELECT);
    }

    public static boolean isSelectOption(Element element) {
        return ElementTypes.isElementWithTag(element, TAG_SELECT_OPTION);
    }

    public static boolean isButton(Element element) {
        return ElementTypes.isElementWithTag(element, "input") && ElementTypes.isElementWithType(element, "button") || ElementTypes.isElementWithTag(element, "button");
    }

    public static boolean isFileUpload(Element element) {
        return ElementTypes.isElementWithTag(element, "input") && ElementTypes.isElementWithType(element, TYPE_FILE_UPLOAD);
    }

    public static boolean isSubmit(Element element) {
        return ElementTypes.isElementWithTag(element, "input") && ElementTypes.isElementWithType(element, TYPE_SUBMIT);
    }

    public static boolean isElementWithType(Element element, String string) {
        if (element != null && string != null) {
            return string.equalsIgnoreCase(element.getAttribute("type"));
        }
        if (element == null) {
            throw new IllegalArgumentException("Element is null.");
        }
        throw new IllegalArgumentException("tagName is null.");
    }

    public static boolean isElementWithTag(Element element, String string) {
        if (element != null && string != null) {
            return string.equalsIgnoreCase(element.getTagName());
        }
        if (element == null) {
            throw new IllegalArgumentException("Element is null.");
        }
        throw new IllegalArgumentException("tagName is null.");
    }
}

