package jp.sourceforge.cfneo.at4ie.api;

import jp.sourceforge.cfneo.at4ie.utils.LocatorUtil;

import org.apache.log4j.Logger;

/**
 * 1̃eXgP[X킷ۃNXB
 * @author imaitakafumi
 *
 */
public abstract class TestCase {

	Logger logger = Logger.getLogger(TestCase.class);

	private Context context;
	private ActionCommandEnum command;
	private String target;
	private String value;

	/**
	 * RXgN^B
	 * @param context
	 * @param command
	 * @param target
	 * @param value
	 */
	public TestCase(Context context,
			ActionCommandEnum command, String target, String value) {
		this.context = context;
		this.command = command;
		this.target = target;
		this.value = value;
	}

	/**
	 * targetElementLocatorw肳Ăꍇ̂value擾B
	 * @return
	 */
	public String getElementValue() {
		logger.debug("TestCase#getElementValue this.target=[" + this.target + "]");
		ElementLocatorEnum elem = LocatorUtil.getElementLocatorEnum(this.target);
		if (elem == null) {
			return null;
		}
		logger.debug("TestCase#getElementValue elem=[" + elem + "]");
		String ret = null;
		if (elem != ElementLocatorEnum.OTHER) {
			ret = LocatorUtil.getLocatorValue(this.target);
		} else {
			ret = LocatorUtil.deleteDoubleQuotation(this.target);
		}
		return ret;
	}
	/**
	 * eXg{B
	 */
	public void doTest() {
		logger.debug("TestCase#doTest this.context=" + this.context);
		logger.debug("TestCase#doTest this.command=" + this.command);
		this.context.getInvokerFactory()
				.getInvoker(this.command).invoke(this);
	}

	/**
	 * eXgP[X̓e𕶎񉻂B
	 */
	public String toString() {
		String command = this.command == null? null: this.command.toString();
		return " command=[" + command
			+ "] target=[" + this.target + "] value=[" + this.value
			+ "] elementValue=[" + this.getElementValue() + "]";
	}

	public ActionCommandEnum getAction() {
		return command;
	}
	protected void setAction(ActionCommandEnum action) {
		this.command = action;
	}
	public String getTarget() {
		return target;
	}
	protected void setTarget(String target) {
		this.target = target;
	}
	public String getValue() {
		return value;
	}
	protected void setValue(String value) {
		this.value = value;
	}

}
